package net.oni2.aeinstaller.gui.corepackages;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;

import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.aeinstaller.gui.modtable.ModSelectionListener;
import net.oni2.aeinstaller.gui.modtable.ModTable;
import net.oni2.aeinstaller.gui.modtable.ModTable.ETableContentType;
import net.oni2.aeinstaller.gui.packageinfobox.PackageInfoBox;
import net.oni2.settingsmanager.Settings;

import org.javabuilders.BuildResult;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class CorePackagesDialog extends JDialog implements ModSelectionListener {
	private static final long serialVersionUID = -5444213842599816301L;

	private ResourceBundle bundle = ResourceBundle
			.getBundle("net.oni2.aeinstaller.localization."
					+ getClass().getSimpleName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private JSplitPane contents;

	private JScrollPane scrollTools;
	private ModTable tblTools;

	private PackageInfoBox pkgInfo;

	/**
	 * Open the dialog
	 */
	public CorePackagesDialog() {
		AbstractAction closeAction = new AbstractAction() {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		};
		KeyStroke ksCtrlW = KeyStroke
				.getKeyStroke('W', KeyEvent.CTRL_DOWN_MASK);
		getRootPane()
				.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
				.put(ksCtrlW, "close");
		getRootPane().getActionMap().put("close", closeAction);

		contents.setDividerLocation(Settings.getInstance().get("win_core_divloc", 550));
		contents.setResizeWeight(0.4);

		tblTools = new ModTable(ETableContentType.CORE);
		tblTools.reloadData();
		scrollTools.setViewportView(tblTools);

		tblTools.addModSelectionListener(this);

		setSize(Settings.getInstance().get("win_core_width", 950), Settings.getInstance().get("win_core_height", 600));
		setLocationRelativeTo(null);
	}

	@Override
	public void modSelectionChanged(ModTable source, Package mod) {
		pkgInfo.updateInfo(mod);
	}

	@SuppressWarnings("unused")
	private void closing() {
		Settings.getInstance().put("win_core_divloc", contents.getDividerLocation());
		Settings.getInstance().put("win_core_width", getWidth());
		Settings.getInstance().put("win_core_height", getHeight());
	}
}
