﻿using System;
using System.Collections.Generic;
using System.Text;

namespace xmlTools
{
    /// <summary>
    /// This class represents a xmlTextValue. It supports various dimensions separated by spaces. For example a vehicle array: "car motorcycle bicycle"
    /// It also includes various functions to work with multi dimensional xml string values
    /// </summary>
    class XmlTextValue
    {
        public List<String> myValues = new List<String>(); //include all dimensions of the value

        public XmlTextValue(String myString)
        {
            String[] values = myString.Split(' ');

            foreach (string value in values)
            {
                this.myValues.Add(value);
            }
        }

        public XmlTextValue(List<String> myDimensions)
        {
            this.myValues = myDimensions;
        }

        public override string ToString()
        {
            String result = "";

            for (int i = 0; i < this.myValues.Count - 1; i++)
            {
                result += this.myValues[i] + " ";
            }
            result += this.myValues[this.myValues.Count - 1];

            return result;
        }
    }
}
