package net.oni2.aeinstaller.gui.downloadwindow;

import java.util.ResourceBundle;
import java.util.TreeSet;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

import net.oni2.aeinstaller.backend.SizeFormatter;
import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.aeinstaller.backend.packages.download.ModDownloader;
import net.oni2.aeinstaller.backend.packages.download.ModDownloaderListener;
import net.oni2.aeinstaller.backend.packages.download.ModDownloader.State;

import org.javabuilders.BuildResult;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class Downloader extends JDialog implements ModDownloaderListener {
	private static final long serialVersionUID = 9097967828001263776L;

	private ResourceBundle bundle = ResourceBundle
			.getBundle("net.oni2.aeinstaller.localization."
					+ getClass().getSimpleName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private JLabel lblNameVal;
	private JLabel lblIsDep;
	private JLabel lblElapsedVal;
	private JLabel lblRemainingVal;
	private JLabel lblDownloadedVal;
	private JLabel lblTotalVal;
	private JLabel lblRateVal;
	private JProgressBar progress;

	private JButton btnAbort;

	private ModDownloader downloader;
	private TreeSet<Package> dependencies = new TreeSet<Package>();

	/**
	 * @param mods
	 *            Mods to download
	 * @param dependencies
	 *            List of mods that only are auto-resolved dependencies
	 */
	public Downloader(TreeSet<Package> mods, TreeSet<Package> dependencies) {
		super();

		setResizable(false);
		setSize(500, (int) getSize().getHeight());

		if (dependencies != null)
			this.dependencies = dependencies;

		downloader = new ModDownloader(mods, this);
		progress.setMaximum(downloader.getTotalSize());
		progress.setStringPainted(true);
		progress.setToolTipText(String.format("%d / %d files downloaded", 0,
				mods.size()));

		lblDownloadedVal.setText(SizeFormatter.format(0, 3));
		lblTotalVal.setText(SizeFormatter.format(downloader.getTotalSize(), 3));
	}

	private void close() {
		if (!downloader.isFinished())
			downloader.abort();
		setVisible(false);
	}

	@SuppressWarnings("unused")
	private boolean confirm() {
		int res = JOptionPane.showConfirmDialog(this,
				bundle.getString("abort.text"),
				bundle.getString("abort.title"), JOptionPane.YES_NO_OPTION,
				JOptionPane.WARNING_MESSAGE);
		return res == JOptionPane.YES_OPTION;
	}

	private String formatTime(int sec) {
		int min = sec / 60;
		sec = sec % 60;
		return String.format("%02d:%02d", min, sec);
	}

	@Override
	public void updateStatus(ModDownloader source, Package currentDownload,
			State state, int filesDown, int filesTotal, int bytesDown,
			int bytesTotal, int duration, int remaining, int speed) {
		if (state == ModDownloader.State.FINISHED) {
			close();
		} else {
			if (state == State.LAST_FILE_DOWNLOADED)
				btnAbort.setEnabled(false);

			progress.setValue(bytesDown);
			progress.setToolTipText(String.format("%d / %d files downloaded",
					filesDown, filesTotal));

			if (currentDownload != null) {
				lblNameVal.setText(currentDownload.getName());
				lblIsDep.setVisible(dependencies.contains(currentDownload));
			} else {
				lblNameVal.setText(bundle.getString("unpacking"));
				lblIsDep.setVisible(false);
			}

			lblElapsedVal.setText(formatTime(duration));
			lblRemainingVal.setText(formatTime(remaining));

			lblDownloadedVal.setText(SizeFormatter.format(bytesDown, 3));

			lblRateVal.setText(SizeFormatter.format(speed, 3) + "/s");
		}
	}

	/**
	 * @return were all downloads finished?
	 */
	public boolean isFinished() {
		return downloader.isFinished();
	}

}
