package net.oni2.aeinstaller.backend.depot.model;

import net.oni2.aeinstaller.backend.depot.JSONHelpers;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class File {
	private int fid;
	private int uid; // User ID of uploader
	private String filename; // Filename
	private String uri; // Internal URI
	private String filemime; // Mimetype
	private int filesize; // Bytes
	private int status; // ???
	private long timestamp; // Timestamp of upload
	private String uri_full; // Full public URI
	private String target_uri; // ???

	/**
	 * @param json
	 *            JSON object of File to parse
	 * @throws JSONException
	 *             On key not found / wrong type
	 */
	public File(JSONObject json) throws JSONException {
		fid = json.getInt("fid");
		uid = json.getInt("uid");
		filename = JSONHelpers.getStringOrNull(json, "filename");
		uri = JSONHelpers.getStringOrNull(json, "uri");
		filemime = JSONHelpers.getStringOrNull(json, "filemime");
		filesize = json.getInt("filesize");
		status = json.getInt("status");
		timestamp = json.getLong("timestamp");
		uri_full = JSONHelpers.getStringOrNull(json, "uri_full");
		target_uri = JSONHelpers.getStringOrNull(json, "target_uri");
	}

	/**
	 * @return the fid
	 */
	public int getFid() {
		return fid;
	}

	/**
	 * @return the uid
	 */
	public int getUid() {
		return uid;
	}

	/**
	 * @return the filename
	 */
	public String getFilename() {
		return filename;
	}

	/**
	 * @return the uri
	 */
	public String getUri() {
		return uri;
	}

	/**
	 * @return the filemime
	 */
	public String getFilemime() {
		return filemime;
	}

	/**
	 * @return the filesize
	 */
	public int getFilesize() {
		return filesize;
	}

	/**
	 * @return the status
	 */
	public int getStatus() {
		return status;
	}

	/**
	 * @return the timestamp
	 */
	public long getTimestamp() {
		return timestamp;
	}

	/**
	 * @return the uri_full
	 */
	public String getUri_full() {
		return uri_full;
	}

	/**
	 * @return the target_uri
	 */
	public String getTarget_uri() {
		return target_uri;
	}

}
