package net.oni2.platformtools.applicationinvoker;

import java.io.File;

import net.oni2.platformtools.PlatformInformation;
import net.oni2.platformtools.PlatformInformation.Platform;

/**
 * @author Christian Illy
 */
public class Java {
	private static int isFound = -1;
	private static File jre = null;

	/**
	 * @return Was a JRE found
	 */
	public static boolean isInstalled() {
		if (isFound < 0) {
			getRuntimeExe();
		}
		return isFound == 1;
	}

	/**
	 * @return The JRE executable
	 */
	public static File getRuntimeExe() {
		if (isFound < 0) {
			File jrehome = new File(System.getProperties().getProperty(
					"java.home"), "bin");
			if (PlatformInformation.getPlatform() == Platform.WIN)
				jre = new File(jrehome, "javaw.exe");
			else
				jre = new File(jrehome, "java");
			if (!jre.exists()) {
				isFound = 0;
				jre = null;
			} else {
				isFound = 1;
			}
		}
		return jre;
	}
}
