package net.oni2.svnaccess;

import java.util.Vector;

import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;


/**
 * Used to get the updated files from SVN between working copy revision and
 * HEAD.
 * 
 * @author Christian Illy
 */
public class LogEntryHandler implements ISVNLogEntryHandler {

	Vector<String>	target;
	String			base;


	/**
	 * Create a new LogEntryHandler with a list to store the found paths to and
	 * a base path in the repository (paths outside are ignored)
	 * 
	 * @param targetList Vector to store the found paths to
	 * @param basePath Base path of folder to look at
	 */
	public LogEntryHandler(Vector<String> targetList, String basePath) {
		this.target = targetList;
		this.base = basePath;
	}

	@Override
	public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
		for (Object o : logEntry.getChangedPaths().keySet()) {
			SVNLogEntryPath p = (SVNLogEntryPath) logEntry.getChangedPaths()
					.get(o);
			if (p.getPath().startsWith(base)) {
				if (p.getType() != 'D')
					if (!target.contains(p.getPath()))
						target.add(p.getPath());
			}
		}
	}

}
