package net.oni2.aeinstaller.backend.oni;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import net.oni2.aeinstaller.backend.CaseInsensitiveFile;
import net.oni2.aeinstaller.backend.Paths;
import net.oni2.platformtools.applicationinvoker.ApplicationInvoker;
import net.oni2.platformtools.applicationinvoker.ApplicationInvocationResult;
import net.oni2.platformtools.applicationinvoker.EExeType;
import net.oni2.platformtools.applicationinvoker.ERuntimeNotInstalledException;

/**
 * @author Christian Illy
 */
public class XMLTools {

	/**
	 * Patch the given XML file with the given patch
	 * 
	 * @param patch
	 *            Patchfile
	 * @param source
	 *            File to patch
	 * 
	 * @return XMLTools output
	 */
	public static ApplicationInvocationResult patch(File patch, File source) {
		Vector<String> params = new Vector<String>();
		// xmlTools.exe patchfile -filename:PATCH -forceinfiles:TOPATCH
		params.add("patchfile");
		params.add("-filename:" + patch.getPath());
		if (source != null)
			params.add("-forceinfiles:" + source.getPath());
		ApplicationInvocationResult res = null;
		try {
			res = ApplicationInvoker.executeAndWait(EExeType.DOTNET, null,
					getProgramFile(), params);
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ERuntimeNotInstalledException e) {
			e.printStackTrace();
		}
		return res;
	}

	private static File getProgramFile() {
		File toolsPath = CaseInsensitiveFile.getCaseInsensitiveFile(
				Paths.getEditionBasePath(), "Tools");
		return CaseInsensitiveFile.getCaseInsensitiveFile(toolsPath,
				"xmlTools.exe");
	}
}
