﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.IO;
using System.Globalization;
using System.Text.RegularExpressions;

namespace xmlTools
{
    class Program
    {
        public static readonly string toolsVersion = "0.8c";
        private static appErrors lastError;

        public enum appErrors
        {
            // 1-19 Errors with input parameters
            ERROR_PARAMS = 1,
            FILE_NOT_FOUND = 2,
            ELEMENT_NOT_SPECIFIED=3,
            ELEMENT_NOT_FOUND=4,
            // 20-199 General application errors
            BACKUPS_ALREADY_EXISTS=20,
            NUMBER_VALUES_TO_REPLACE_NE_AVAILABLE_VALUES = 21,
            INVALID_POSITIONS_RANGE=22,
            // 200-299 Patch operations errors
            PATCH_ADDTO_PROCESS_ERROR = 200,
            PATCH_REMOVE_PROCESS_ERROR = 201,
            PATCH_COMMAND_PROCESS_ERROR=202,
            PATCH_ELEMENT_NOT_FOUND=203,
            PATCH_ADDTO_ERROR_PARSING_XML=204,
            PATCH_COMMAND_NOT_FOUND=205
        }

        public static void printAppError(appErrors error, string description, bool exitApp=false){
            Console.Error.WriteLine("Error Code: "+(int)error);
            Console.Error.WriteLine(description);

            if (exitApp)
            {
                Environment.Exit(1);
            }

            lastError = error;
        }

        public static int Main(string[] args)
        {
            try
            {
                //We use a command parse library due to its advantages
                CLAP.Parser.RunConsole<ParametersParser>(args);
                return (int)lastError;
            }
            catch (Exception e)
            {
                printAppError(appErrors.ERROR_PARAMS, "Error processing parameters:\n" + e.ToString());
                return (int)appErrors.ERROR_PARAMS;
            }
        }
    }
}
