package net.oni2.moddepot;

import java.util.HashSet;

/**
 * @author Christian Illy
 */
public class DepotConfig {
	/**
	 * Node type for package nodes
	 */
	public static String nodeType_Package = "mod";
	/**
	 * Vocabulary name for the platform terms
	 */
	public static String vocabName_Platform = "Platform";
	/**
	 * Vocabulary name for the install type terms
	 */
	public static String vocabName_InstallType = "Install method";
	/**
	 * Vocabulary name for the mod type terms
	 */
	public static String vocabName_ModType = "Mod type";

	/**
	 * Taxonomy term name for the win platform
	 */
	public static String taxName_Platform_Win = "Windows";
	/**
	 * Taxonomy term name for the mac platform
	 */
	public static String taxName_Platform_MacOS = "Mac OS";
	/**
	 * Taxonomy term name for platform independent
	 */
	public static String taxName_Platform_Both = "Both";

	/**
	 * Taxonomy term name for package install type
	 */
	public static String taxName_InstallType_Package = "Package";

	/**
	 * Package number at which non-core packages start
	 */
	public static int corePackageNumberLimit = 8000;

	/**
	 * URL of depot
	 */
	public static String depotUrl = "http://mods.oni2.net/";

	/**
	 * @return Taxonomy term names for mods of type Tool
	 */
	public static HashSet<String> getTaxonomyName_ModType_Tool() {
		HashSet<String> res = new HashSet<String>();
		res.add("Tool");
		res.add("Patch");
		return res;
	}

}
