package net.oni2.moddepot;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class JSONHelpers {
	/**
	 * Return the string associated with the given key or null if the key does
	 * not exist or does not contain a string
	 * 
	 * @param parent
	 *            Parent JSON object
	 * @param key
	 *            Key to look for
	 * @return Contained string or null
	 */
	public static String getStringOrNull(JSONObject parent, String key) {
		try {
			Object obj = parent.get(key);
			if (obj instanceof String)
				return (String) obj;
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return null;
	}
}
