package net.oni2.moddepot.model;

import net.oni2.moddepot.JSONHelpers;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class NodeField_Body {
	private String summary;
	private String value;
	private String safe_summary;
	private String safe_value;
	private int format;

	/**
	 * @param json
	 *            JSON object of body-entry to parse
	 * @throws JSONException
	 *             On key not found / wrong type
	 */
	public NodeField_Body(JSONObject json) throws JSONException {
		summary = JSONHelpers.getStringOrNull(json, "summary");
		value = JSONHelpers.getStringOrNull(json, "value");
		safe_summary = JSONHelpers.getStringOrNull(json, "safe_summary");
		safe_value = JSONHelpers.getStringOrNull(json, "safe_value");
		format = json.getInt("format");
	}

	/**
	 * @return the summary
	 */
	public String getSummary() {
		return summary;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @return the safe_summary
	 */
	public String getSafe_summary() {
		return safe_summary;
	}

	/**
	 * @return the safe_value
	 */
	public String getSafe_value() {
		return safe_value;
	}

	/**
	 * @return the format
	 */
	public int getFormat() {
		return format;
	}
}
