package net.oni2.moddepot.model;

import net.oni2.moddepot.JSONHelpers;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class NodeField_Upload {

	private long timestamp; // Time of upload
	private int uid; // User ID of uploader
	private int fid; // File ID
	private int filesize; // Size in bytes
	private String status; // ???
	private String description;// Description
	private String filename; // Filename
	private int display; // isVisible
	private String filemime; // Mimetype
	private String uri; // Private URI

	/**
	 * @param json
	 *            JSON object of upload-entry to parse
	 * @throws JSONException
	 *             On key not found / wrong type
	 */
	public NodeField_Upload(JSONObject json) throws JSONException {
		timestamp = json.getLong("timestamp");
		uid = json.getInt("uid");
		fid = json.getInt("fid");
		filesize = json.getInt("filesize");
		status = JSONHelpers.getStringOrNull(json, "status");
		description = JSONHelpers.getStringOrNull(json, "description");
		filename = JSONHelpers.getStringOrNull(json, "filename");
		display = json.getInt("display");
		filemime = JSONHelpers.getStringOrNull(json, "filemime");
		uri = JSONHelpers.getStringOrNull(json, "uri");
	}

	/**
	 * @return the timestamp
	 */
	public long getTimestamp() {
		return timestamp;
	}

	/**
	 * @return the uid
	 */
	public int getUid() {
		return uid;
	}

	/**
	 * @return the fid
	 */
	public int getFid() {
		return fid;
	}

	/**
	 * @return the filesize
	 */
	public int getFilesize() {
		return filesize;
	}

	/**
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return the filename
	 */
	public String getFilename() {
		return filename;
	}

	/**
	 * @return the display
	 */
	public int getDisplay() {
		return display;
	}

	/**
	 * @return the filemime
	 */
	public String getFilemime() {
		return filemime;
	}

	/**
	 * @return the uri
	 */
	public String getUri() {
		return uri;
	}
}
