package net.oni2.moddepot.model;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class TaxonomyTerm {
	private int tid;
	private int vid;
	private String name;
	private String description;
	private String uri;

	/**
	 * @param json
	 *            JSONObject containing the item
	 * @throws JSONException
	 *             If a key can't be found
	 */
	public TaxonomyTerm(JSONObject json) throws JSONException {
		tid = json.getInt("tid");
		vid = json.getInt("vid");
		name = json.getString("name");
		description = json.getString("description");
		uri = json.getString("uri");
	}

	/**
	 * @return the term ID (tid)
	 */
	public int getTid() {
		return tid;
	}

	/**
	 * @return the vocabulary ID (vid)
	 */
	public int getVid() {
		return vid;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return the uri
	 */
	public String getUri() {
		return uri;
	}
	
	@Override
	public String toString() {
		return getName();
	}
}
