package net.oni2.moddepot.model;

import net.oni2.moddepot.JSONHelpers;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class Node {
	private int uid; // User ID of editor
	private int nid; // Node ID

	private NodeField_Body body;

	private String data; // ???
	private int last_comment_uid; // User ID of author of last comment
	private String last_comment_name; // Name of author of last comment
	private long last_comment_timestamp; // Timestamp of post time of last
											// comment
	private int comment_count; // Number of comments
	private String type; // Type of node ("story", "page", "mod" ...)
	private long changed; // Timestamp of last change
	private String title; // Title of node
	private long created; // Timestamp of node creation
	private String name; // Name of user who created the node
	private String path; // URI of node
	private int revision_uid; // User ID of author of last revision
	private int tnid; // ???
	private int vid; // Revision VID of latest revision
	private int status; // ??? perhaps published etc?
	private String log; // ???
	private int cid; // ???
	private int picture; // ???
	private int sticky; // Is sticky on news overview?
	private int promote; // (???) Is promoted?
	private long revision_timestamp; // Timestamp of last revision
	private int translate; // ???
	private String language; // Languagecode of content
	private String comment; // ???

	/**
	 * @param json
	 *            JSON object of Node to parse
	 * @throws JSONException
	 *             On key not found / wrong type
	 */
	public Node(JSONObject json) throws JSONException {
		uid = json.getInt("uid");
		nid = json.getInt("nid");

		Object bodyObj = json.get("body");
		if (bodyObj instanceof JSONObject) {
			JSONObject jBody = ((JSONObject) bodyObj).getJSONArray("und").getJSONObject(0);
			body = new NodeField_Body(jBody);
		}
		data = JSONHelpers.getStringOrNull(json, "data");
		last_comment_uid = json.getInt("last_comment_uid");
		last_comment_name = JSONHelpers.getStringOrNull(json,
				"last_comment_name");
		last_comment_timestamp = json.getLong("last_comment_timestamp");
		comment_count = json.getInt("comment_count");
		type = JSONHelpers.getStringOrNull(json, "type");
		changed = json.getLong("changed");
		title = JSONHelpers.getStringOrNull(json, "title");
		created = json.getLong("created");
		name = JSONHelpers.getStringOrNull(json, "name");
		path = JSONHelpers.getStringOrNull(json, "path");
		revision_uid = json.getInt("revision_uid");
		tnid = json.getInt("tnid");
		vid = json.getInt("vid");
		status = json.getInt("status");
		log = JSONHelpers.getStringOrNull(json, "log");
		cid = json.getInt("cid");
		picture = json.getInt("picture");
		sticky = json.getInt("sticky");
		promote = json.getInt("promote");
		revision_timestamp = json.getLong("revision_timestamp");
		translate = json.getInt("translate");
		language = JSONHelpers.getStringOrNull(json, "language");
		comment = JSONHelpers.getStringOrNull(json, "comment");
	}

	/**
	 * @return the uid
	 */
	public int getUid() {
		return uid;
	}

	/**
	 * @return the nid
	 */
	public int getNid() {
		return nid;
	}

	/**
	 * @return the body
	 */
	public NodeField_Body getBody() {
		return body;
	}

	/**
	 * @return the data
	 */
	public String getData() {
		return data;
	}

	/**
	 * @return the last_comment_uid
	 */
	public int getLast_comment_uid() {
		return last_comment_uid;
	}

	/**
	 * @return the last_comment_name
	 */
	public String getLast_comment_name() {
		return last_comment_name;
	}

	/**
	 * @return the last_comment_timestamp
	 */
	public long getLast_comment_timestamp() {
		return last_comment_timestamp;
	}

	/**
	 * @return the comment_count
	 */
	public int getComment_count() {
		return comment_count;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @return the changed
	 */
	public long getChanged() {
		return changed;
	}

	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @return the created
	 */
	public long getCreated() {
		return created;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the path
	 */
	public String getPath() {
		return path;
	}

	/**
	 * @return the revision_uid
	 */
	public int getRevision_uid() {
		return revision_uid;
	}

	/**
	 * @return the tnid
	 */
	public int getTnid() {
		return tnid;
	}

	/**
	 * @return the vid
	 */
	public int getVid() {
		return vid;
	}

	/**
	 * @return the status
	 */
	public int getStatus() {
		return status;
	}

	/**
	 * @return the log
	 */
	public String getLog() {
		return log;
	}

	/**
	 * @return the cid
	 */
	public int getCid() {
		return cid;
	}

	/**
	 * @return the picture
	 */
	public int getPicture() {
		return picture;
	}

	/**
	 * @return the sticky
	 */
	public int getSticky() {
		return sticky;
	}

	/**
	 * @return the promote
	 */
	public int getPromote() {
		return promote;
	}

	/**
	 * @return the revision_timestamp
	 */
	public long getRevision_timestamp() {
		return revision_timestamp;
	}

	/**
	 * @return the translate
	 */
	public int getTranslate() {
		return translate;
	}

	/**
	 * @return the language
	 */
	public String getLanguage() {
		return language;
	}

	/**
	 * @return the comment
	 */
	public String getComment() {
		return comment;
	}

}
