package net.oni2.moddepot.model;

import java.util.HashSet;
import java.util.Vector;

import net.oni2.moddepot.DepotConfig;
import net.oni2.moddepot.DepotManager;
import net.oni2.moddepot.ECompatiblePlatform;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class NodeMod extends Node {
	private Vector<File> uploads = new Vector<File>();

	private ECompatiblePlatform platform = null;
	private String installType = null;
	private HashSet<String> packageType = new HashSet<String>();

	private String creator = "";
	private String version = "";
	private int package_number = -1;

	/**
	 * @param json
	 *            JSON object of Mod-node to parse
	 * @throws JSONException
	 *             On key not found / wrong type
	 */
	public NodeMod(JSONObject json) throws JSONException {
		super(json);

		Object uploadObj = json.get("upload");
		if (uploadObj instanceof JSONObject) {
			JSONArray jUploads = ((JSONObject) uploadObj).getJSONArray("und");
			for (int i = 0; i < jUploads.length(); i++) {
				NodeField_Upload up = new NodeField_Upload(
						jUploads.getJSONObject(i));
				if (up.getDisplay() != 0) {
					uploads.add(DepotManager.getInstance().getFile(up.getFid()));
				}
			}
		}

		for (Object key : json.keySet()) {
			String keyS = ((String) key).toLowerCase();
			Object val = json.get(keyS);
			if (keyS.startsWith("field_")) {
				String fName = keyS.substring(keyS.indexOf("_") + 1);
				String value = "";
				if (val instanceof JSONObject) {
					value = ((JSONObject) val).getJSONArray("und")
							.getJSONObject(0).getString("value");
				}
				if (fName.equalsIgnoreCase("version"))
					version = value;
				else if (fName.equalsIgnoreCase("creator"))
					creator = value;
				else if (fName.equalsIgnoreCase("package_number")) {
					try {
						package_number = Integer.parseInt(value);
					} catch (NumberFormatException e) {
					}
				}
			}

			if (keyS.startsWith("taxonomy_vocabulary_")) {
				int vid = Integer
						.parseInt(keyS.substring(keyS.lastIndexOf("_") + 1));

				if (val instanceof JSONObject) {
					JSONArray ja = ((JSONObject) val).getJSONArray("und");

					if (vid == DepotManager.getInstance().vocabId_platform) {
						int tid = ja.getJSONObject(0).getInt("tid");
						String validPlatform = DepotManager.getInstance()
								.getTaxonomyTerm(tid).getName();
						if (validPlatform
								.equalsIgnoreCase(DepotConfig.taxName_Platform_Both))
							platform = ECompatiblePlatform.BOTH;
						else if (validPlatform
								.equalsIgnoreCase(DepotConfig.taxName_Platform_Win))
							platform = ECompatiblePlatform.WIN;
						else if (validPlatform
								.equalsIgnoreCase(DepotConfig.taxName_Platform_MacOS))
							platform = ECompatiblePlatform.MACOS;
					} else if (vid == DepotManager.getInstance().vocabId_type) {
						for (int i = 0; i < ja.length(); i++) {
							int tid = ja.getJSONObject(i).getInt("tid");
							packageType.add(DepotManager.getInstance()
									.getTaxonomyTerm(tid).getName());
						}
					} else if (vid == DepotManager.getInstance().vocabId_instmethod) {
						int tid = ja.getJSONObject(0).getInt("tid");
						installType = DepotManager.getInstance()
								.getTaxonomyTerm(tid).getName();
					}
				}

			}
		}
	}

	/**
	 * @return the uploads
	 */
	public Vector<File> getUploads() {
		return uploads;
	}

	/**
	 * @return Types
	 */
	public HashSet<String> getTypes() {
		return packageType;
	}

	/**
	 * @return Install method
	 */
	public String getInstallMethod() {
		return installType;
	}

	/**
	 * @return Compatible platform
	 */
	public ECompatiblePlatform getPlatform() {
		return platform;
	}

	/**
	 * @return Creator of mod
	 */
	public String getCreator() {
		return creator;
	}

	/**
	 * @return Version of mod
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * @return Package number
	 */
	public int getPackageNumber() {
		return package_number;
	}

	/**
	 * @return Is this mod a tool?
	 */
	public boolean isTool() {
		HashSet<String> types = getTypes();
		for (String s : DepotConfig.getTaxonomyName_ModType_Tool()) {
			for (String type : types)
				if (type.equalsIgnoreCase(s))
					return true;
		}
		return false;
	}
}
