package net.oni2.aeinstaller.backend.packages;

import java.util.HashSet;

/**
 * @author Christian Illy
 */
public class Type {
	private String name;

	private HashSet<Package> entries = new HashSet<Package>();

	/**
	 * Create a new local type declaration
	 * 
	 * @param name
	 *            Name of type
	 */
	public Type(String name) {
		this.name = name;
	}

	void addEntry(Package m) {
		entries.add(m);
	}

	/**
	 * @return Name of type
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return Entries for type
	 */
	public HashSet<Package> getEntries() {
		return entries;
	}

	@Override
	public String toString() {
		return String.format("%s (%d)", name, entries.size());
	}
}
