package net.oni2.aeinstaller;

import java.util.HashMap;
import java.util.HashSet;

import net.oni2.moddepot.DepotConfig;
import net.oni2.moddepot.DepotManager;
import net.oni2.moddepot.model.Node;
import net.oni2.moddepot.model.NodeMod;

/**
 * @author Christian Illy
 */
public class DepotPackageCheck {

	/**
	 * @param args
	 *            Arguments
	 */
	public static void main(String[] args) {
		System.out.println("Reading Depot data:");
		DepotManager.getInstance().updateInformation();
		System.out.println("\nReading done");
		System.out.println();

		System.out.println();

		printModsWithFilesNot1();
	}

	private static void printModsWithFilesNot1() {
		System.out.println("Mod-Nodes with files != 1:");

		HashMap<String, HashSet<NodeMod>> foundNodes = new HashMap<String, HashSet<NodeMod>>();
		for (Node n : DepotManager.getInstance().getNodesByType(
				DepotConfig.nodeType_Package)) {
			NodeMod nm = (NodeMod) n;
			if (nm.getUploads().size() != 1) {
				if (!foundNodes.containsKey(nm.getInstallMethod()))
					foundNodes.put(nm.getInstallMethod(),
							new HashSet<NodeMod>());
				foundNodes.get(nm.getInstallMethod()).add(nm);
			}
		}

		for (String inst : foundNodes.keySet()) {
			System.out.format("Inst method '%s':\n", inst);
			for (NodeMod nm : foundNodes.get(inst)) {
				System.out
						.format("  Node %3d, Files %d, Platform %5s, Type %11s, Submitter %10s, Title \"%s\"\n",
								nm.getNid(), nm.getUploads().size(), nm
										.getPlatform().toString(), nm
										.getTypes().toString(), nm.getName(),
								nm.getTitle());
			}
			System.out.println();
		}
	}

}
