Public Type LWOPolygon
  NumVe As Integer
  P1 As Integer
  P2 As Integer
  P3 As Integer
  Surfa As Integer
End Type

Public Type PolDef
  P1 As Integer
  P2 As Integer
  P3 As Integer
End Type

'Texture Coordinate Entry
Public Type TXCAentry
  X As Single
  Y As Single
End Type

'Texture Coordinate Lists
Public Type TXCA            'Length
  ID As Long                '4
  Version As Long           '8
  Filler(1 To 5) As Long    '28
  NumEntries As Long        '32
End Type

'Level Data Reference List
Public Type ONLV            'Length
  ID As Long                '4
  Version As Long           '8
  LevelName As String * 64  '72
  AKEVid As Long            '76
  OBOAid As Long            '80
  ONMAid As Long            '84
  ONFAid As Long            '88
  ONTAid As Long            '92
  ONSKid As Long            '96
  Unkn As Long              '100
  AISAid As Long            '104
  AITRid As Long            '108
  ONSAid As Long            '112
  OBDCid As Long            '116
  ONOAid As Long            '120
  Fill(1 To 161) As Long    '764
  CRSAid As Long            '768
End Type

Public Type AGQG
  ID As Long
  unk(1 To 24) As Byte
  NumEntries As Long
End Type

Public Type AGQGEntry
  VertIndex(1 To 4) As Long
  VertUVIndex(1 To 4) As Long
  LData_1(1 To 4) As Byte
  LData_2(1 To 4) As Byte
  LData_3(1 To 4) As Byte
  LData_4(1 To 4) As Byte
  unk(1 To 2) As Long
End Type

Public Type AGQREntry
  TexIndex As Integer
  unk As Integer
End Type

Public Type TXMA
   ID As Long
   shit(1 To 24) As Byte
   NumEntries As Long
End Type

Public Type TXMAEntry
   TXMP_ID As Long
End Type





Public Sub CExportONLV(Optional FileName As String)
Form1.StatusBar1.SimpleText = "Status: Extracting LEVEL....."
Dim ID4 As Long
Dim I As Long
Dim L As Long
Dim LwoP() As LWOPolygon
Dim OniPol2() As PolDef
Dim NP As Long
Dim numb As Long

Dim TXMA1 As TXMA
Dim AGQR1 As TXMA
Dim TXCA1 As TXCA
Dim TXCA_E() As TXCAentry
Dim TXMA_E() As TXMAEntry
Dim AGQR_E() As AGQREntry
Dim TexNames() As String

If FileName = "" Then
  Form1.CD.DialogTitle = "Unpack resource..."
  Form1.CD.FileName = OniEntry(Curr).szTagName
  Form1.CD.Filter = "LightWave (*.lwo)|*.lwo"
  Form1.CD.Flags = &H2 + &H4
  Form1.CD.ShowSave
  FileName = Form1.CD.FileName
  If FileName = "" Then Exit Sub
End If

DoEvents

Open DatFile For Binary As #1
  Get 1, OniEntry(Curr).rDataPosition, ONLV
  For I = 0 To UBound(OniEntry) - 1
    Get 1, OniEntry(I).rDataPosition, ID4
    If ID4 = ONLV.AKEVid Then
      Get 1, OniEntry(I).rDataPosition, AKEV
      Exit For
    End If
  Next I

  'Find ID of PNTA
  For I = 0 To UBound(OniEntry) - 1
    Get 1, OniEntry(I).rDataPosition, ID4
    If ID4 = AKEV.PNTAid Then
       Get 1, OniEntry(I).rDataPosition, PNTA
       ReDim PNTAentry(PNTA.NumEntries - 1)
       Get 1, , PNTAentry
       Exit For
    End If
  Next I

  For I = 0 To UBound(OniEntry) - 1
    Get 1, OniEntry(I).rDataPosition, ID4
    If ID4 = AKEV.AGQGid Then
       Get 1, OniEntry(I).rDataPosition, AGQG
       ReDim AGQGEntry(AGQG.NumEntries - 1)
       Get 1, , AGQGEntry
       Exit For
    End If
  Next I

  'TXCA
  For I = 0 To UBound(OniEntry) - 1
    Get 1, OniEntry(I).rDataPosition, ID4
    If ID4 = AKEV.TXCAid Then
       Get 1, OniEntry(I).rDataPosition, TXCA1
       ReDim TXCA_E(TXCA1.NumEntries - 1)
       Get 1, , TXCA_E
       ReDim Preserve TXCA_E(PNTA.NumEntries - 1)
       Exit For
    End If
  Next I

  'TXMA
  For I = 0 To UBound(OniEntry) - 1
    Get 1, OniEntry(I).rDataPosition, ID4
    If ID4 = AKEV.TXMAid Then
       Get 1, OniEntry(I).rDataPosition, TXMA1
       ReDim TXMA_E(TXMA1.NumEntries - 1)
       Get 1, , TXMA_E
       Exit For
    End If
  Next I

  'AGQR
  For I = 0 To UBound(OniEntry) - 1
    Get 1, OniEntry(I).rDataPosition, ID4
    If ID4 = AKEV.AGQRid Then
       Get 1, OniEntry(I).rDataPosition, AGQR1
       ReDim AGQR_E(AGQR1.NumEntries - 1)
       Get 1, , AGQR_E
       Exit For
    End If
  Next I

  ReDim TexNames(TXMA1.NumEntries - 1)

  For I = 0 To TXMA1.NumEntries - 1
    For L = 0 To UBound(OniEntry) - 1
      Get 1, OniEntry(L).rDataPosition, ID4
      If ID4 = TXMA_E(I).TXMP_ID Then
        TexNames(I) = OniEntry(L).szTagName + Ext
        Exit For
      End If
    Next L
  Next I

Close
'Ok
' so we have: 3D points, Texture coordinates and list of polygons,
' end reading, now convert data
I = 0
Open App.Path + "\lwo.tmp" For Binary As #11
Form1.StatusBar1.SimpleText = "Status: Extracting LEVEL [Reading Polygons...]"
Seek 11, 1

'reading polygons.......

NP = AGQG.NumEntries * 2
For I = 0 To AGQG.NumEntries - 1
Select Case GetPureFile(TexNames(AGQR_E(I).TexIndex))
  Case "BLUEGRID02", "_DOOR_FRAME", "", "COLLISION"
  NP = NP - 2
  Case Else
    Select Case Mid$(GetPureFile(TexNames(AGQR_E(I).TexIndex)), 1, 5)
     Case "_DOOR"
       NP = NP - 2
     Case Else
       Put 11, , TestSwapInt(AGQGEntry(I).VertIndex(1))
       Put 11, , TestSwapInt(AGQGEntry(I).VertIndex(2))
       Put 11, , TestSwapInt(AGQGEntry(I).VertIndex(3))
       Put 11, , TestSwapInt(AGQGEntry(I).VertIndex(3))
       Put 11, , TestSwapInt(AGQGEntry(I).VertIndex(4))
       Put 11, , TestSwapInt(AGQGEntry(I).VertIndex(1))
    End Select
  End Select
Next I



ReDim OniPol2(NP - 1)
ReDim LwoP(NP - 1)
Get 11, 1, OniPol2

For I = 0 To NP - 1
  LwoP(I).NumVe = ISItoMSI(3)
  LwoP(I).P1 = OniPol2(I).P1
  LwoP(I).P2 = OniPol2(I).P2
  LwoP(I).P3 = OniPol2(I).P3
  LwoP(I).Surfa = ISItoMSI(1)
Next I

I = Empty

Close

On Error Resume Next
  Kill App.Path + "\*.tmp"
On Error GoTo 0

Form1.StatusBar1.SimpleText = "Status: Extracting LEVEL [Writing...]"
Form1.ProgressBar1.Max = PNTA.NumEntries
Form1.ProgressBar1.Value = 0
If LevelType = 5 Or LevelType = 10 Then
  FileName = GetPureFile(FileName) + ".raw"
End If

For I = 0 To PNTA.NumEntries - 1
   If PNTAentry(I).X > 2000000.1 Then PNTAentry(I).X = 0
   If PNTAentry(I).Y > 2000000.1 Then PNTAentry(I).Y = 0
   If PNTAentry(I).Z > 2000000.1 Then PNTAentry(I).Z = 0
   If PNTAentry(I).X < -2000000.1 Then PNTAentry(I).X = 0
   If PNTAentry(I).Y < -2000000.1 Then PNTAentry(I).Y = 0
   If PNTAentry(I).Z < -2000000.1 Then PNTAentry(I).Z = 0
Next I

Select Case LevelType
Case 1

Open FileName For Binary As #1
  Put 1, , "FORM"
  Put 1, , ISLtoMSL(12 + (PNTA.NumEntries * 12) + 8 + 6 + 8 + (NP * 10))
  Put 1, , "LWOBPNTS"
  Put 1, , ISLtoMSL(PNTA.NumEntries * 12)
  For I = 0 To PNTA.NumEntries - 1
    Put 1, , SwapFloat(PNTAentry(I).X)
    Put 1, , SwapFloat(PNTAentry(I).Y)
    Put 1, , SwapFloat(PNTAentry(I).Z)
    Form1.ProgressBar1.Value = I
  Next I
  Put 1, , "SRFS"
  Put 1, , ISLtoMSL(6)
  Put 1, , "Level"
  Put 1, , CByte(0)
  Put 1, , "POLS"
  Put 1, , ISLtoMSL(NP * 10)
  Put 1, , LwoP
Close
Case 6

' Convert Oni level to RAW 3D Binary
Open GetPureFile(FileName) + ".rwb" For Binary As #1
For I = 0 To AGQG.NumEntries - 1
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(1)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(1)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(1)).Z
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(2)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(2)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(2)).Z
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(3)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(3)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(3)).Z
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(3)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(3)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(3)).Z
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(4)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(4)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(4)).Z
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(1)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(1)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(1)).Z
Next I

Close
Case 7

' B3D
Open GetPureFile(FileName) + ".b3d" For Binary As #1
Put 1, , "Big3DbyOleg"
Put 1, , CLng(1067030938)
Put 1, , "POINTS  "
Put 1, , CLng(PNTA.NumEntries)
For I = 0 To PNTA.NumEntries - 1
  Put 1, , PNTAentry(I).X
  Put 1, , PNTAentry(I).Y
  Put 1, , PNTAentry(I).Z
Next I

Put 1, , "POLYGONS"
Put 1, , CLng(NP * 2)
For I = 0 To AGQG.NumEntries - 1
Select Case GetPureFile(TexNames(AGQR_E(I).TexIndex))
  Case "BLUEGRID02", "_DOOR_FRAME", "", "COLLISION"
    'nothing
  Case Else
    Select Case Mid$(GetPureFile(TexNames(AGQR_E(I).TexIndex)), 1, 5)
     Case "_DOOR"
       'nothing
     Case Else
       Put 1, , CLng(3)
       Put 1, , AGQGEntry(I).VertIndex(1)
       Put 1, , AGQGEntry(I).VertIndex(2)
       Put 1, , AGQGEntry(I).VertIndex(3)
       Put 1, , CLng(0)
       Put 1, , CLng(3)
       Put 1, , AGQGEntry(I).VertIndex(3)
       Put 1, , AGQGEntry(I).VertIndex(4)
       Put 1, , AGQGEntry(I).VertIndex(1)
       Put 1, , CLng(0)
    End Select
End Select
Next I
Put 1, , CLng(0)
Close

Case 8

'Delete shit from the Oni level
numb = AGQG.NumEntries
   ReDim Preserve PNTAentry(PNTA.NumEntries + 3)
   PNTAentry(PNTA.NumEntries + 0).X = -9
   PNTAentry(PNTA.NumEntries + 0).Y = 0
   PNTAentry(PNTA.NumEntries + 0).Z = -3
   PNTAentry(PNTA.NumEntries + 1).X = -9
   PNTAentry(PNTA.NumEntries + 1).Y = 0
   PNTAentry(PNTA.NumEntries + 1).Z = 8
   PNTAentry(PNTA.NumEntries + 2).X = 11
   PNTAentry(PNTA.NumEntries + 2).Y = 0
   PNTAentry(PNTA.NumEntries + 2).Z = -3
   PNTAentry(PNTA.NumEntries + 3).X = 11
   PNTAentry(PNTA.NumEntries + 3).Y = 0
   PNTAentry(PNTA.NumEntries + 3).Z = 8

   If Form1.mnuDelGarbage.Checked = True Then
   For I = 0 To AGQG.NumEntries - 1
     Select Case Mid$(GetPureFile(TexNames(AGQR_E(I).TexIndex)), 1, 5)
     Case "_DOOR"
        AGQGEntry(I).VertIndex(1) = PNTA.NumEntries + 0
        AGQGEntry(I).VertIndex(2) = PNTA.NumEntries + 1
        AGQGEntry(I).VertIndex(3) = PNTA.NumEntries + 2
        AGQGEntry(I).VertIndex(4) = PNTA.NumEntries + 3
        'numb = numb - 1
     End Select
   Next I
   End If

   For I = 0 To AGQG.NumEntries - 1
     Select Case GetPureFile(TexNames(AGQR_E(I).TexIndex))
     Case "BLUEGRID02", "_DOOR_FRAME", "", "COLLISION"
        AGQGEntry(I).VertIndex(1) = PNTA.NumEntries + 0
        AGQGEntry(I).VertIndex(2) = PNTA.NumEntries + 1
        AGQGEntry(I).VertIndex(3) = PNTA.NumEntries + 2
        AGQGEntry(I).VertIndex(4) = PNTA.NumEntries + 3
        numb = numb - 1
     End Select
   Next I

'B3D + materials
Open GetPureFile(FileName) + ".b3d" For Binary As #1
Put 1, , "Big3DbyOleg"
Put 1, , CLng(1067030938)
Put 1, , "POINTS  "
Put 1, , CLng(numb * 4)

For I = 0 To AGQG.NumEntries - 1
  ' Begin polygon
Select Case GetPureFile(TexNames(AGQR_E(I).TexIndex))
 Case "BLUEGRID02", "_DOOR_FRAME", "", "COLLISION"
  'nothing
 Case Else
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(1)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(1)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(1)).Z

  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(2)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(2)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(2)).Z

  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(3)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(3)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(3)).Z

  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(4)).X
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(4)).Y
  Put 1, , PNTAentry(AGQGEntry(I).VertIndex(4)).Z
End Select
  ' end polygon
Next I

Put 1, , "POLYGONS"
Put 1, , CLng(numb * 2)
L = 0
ID4 = 0
For I = 0 To AGQG.NumEntries - 1
Select Case GetPureFile(TexNames(AGQR_E(I).TexIndex))
 Case "BLUEGRID02", "_DOOR_FRAME", "", "COLLISION"
  'nothing
 Case Else
  Put 1, , CLng(3)
  Put 1, , CLng(L)
  Put 1, , CLng(L + 1)
  Put 1, , CLng(L + 2)
  Put 1, , CLng(ID4)
  Put 1, , CLng(3)
  Put 1, , CLng(L + 2)
  Put 1, , CLng(L + 3)
  Put 1, , CLng(L)
  Put 1, , CLng(ID4)
  ID4 = ID4 + 1
  L = L + 4
End Select
Next I

Put 1, , CLng(1)
Put 1, , "TEX_UV  "
Put 1, , CLng(numb * 4)
L = 0

For I = 0 To AGQG.NumEntries - 1
Select Case GetPureFile(TexNames(AGQR_E(I).TexIndex))
 Case "BLUEGRID02", "_DOOR_FRAME", "", "COLLISION"
  'nothing
 Case Else
  Put 1, , CLng(L)
  L = L + 1
  Put 1, , TXCA_E(AGQGEntry(I).VertUVIndex(1)).X
  Put 1, , TXCA_E(AGQGEntry(I).VertUVIndex(1)).Y
  Put 1, , CLng(L)
  L = L + 1
  Put 1, , TXCA_E(AGQGEntry(I).VertUVIndex(2)).X
  Put 1, , TXCA_E(AGQGEntry(I).VertUVIndex(2)).Y
  Put 1, , CLng(L)
  L = L + 1
  Put 1, , TXCA_E(AGQGEntry(I).VertUVIndex(3)).X
  Put 1, , TXCA_E(AGQGEntry(I).VertUVIndex(3)).Y
  Put 1, , CLng(L)
  L = L + 1
  Put 1, , TXCA_E(AGQGEntry(I).VertUVIndex(4)).X
  Put 1, , TXCA_E(AGQGEntry(I).VertUVIndex(4)).Y
End Select
  'Put 1, , CSng((-TXCA_E(I).Y) + 1)
Next I

L = 0
Put 1, , "MATERIAL"
Put 1, , CLng(numb)
For I = 0 To AGQG.NumEntries - 1
Select Case GetPureFile(TexNames(AGQR_E(I).TexIndex))
 Case "BLUEGRID02", "_DOOR_FRAME", "", "COLLISION"
  'nothing
 Case Else
  Put 1, , CLng(1)
  Put 1, , CLng(L)
  Put 1, , CLng(Len(TexNames(AGQR_E(I).TexIndex)))
  Put 1, , TexNames(AGQR_E(I).TexIndex)
  L = L + 1
End Select
Next I
Close

Open GetPureFile(FileName) + ".tlist" For Binary As #4
  For I = 0 To AGQR1.NumEntries - 1
  Select Case GetPureFile(TexNames(AGQR_E(I).TexIndex))
  Case "BLUEGRID02", "_DOOR_FRAME", "", "COLLISION"
   'nothing
  Case Else
    Put 4, , AGQR_E(I).TexIndex
  End Select
  Next I
Close

Open GetPureFile(FileName) + ".txt" For Output As #4
  Print #4, CStr(TXMA1.NumEntries)
  For I = 0 To TXMA1.NumEntries - 1
    Print #4, CStr(GetPureFile(TexNames(I)))
  Next I
Close

If Form1.mnuB3DLight.Checked = True Then
Open GetPureFile(FileName) + ".ltcs" For Binary As #4
  For I = 0 To AGQR1.NumEntries - 1
  Select Case GetPureFile(TexNames(AGQR_E(I).TexIndex))
  Case "BLUEGRID02", "_DOOR_FRAME", "", "COLLISION"
   'nothing
  Case Else
    Put 4, , AGQGEntry(I).LData_1
    Put 4, , AGQGEntry(I).LData_2
    Put 4, , AGQGEntry(I).LData_3
    Put 4, , AGQGEntry(I).LData_4
  End Select
  Next I
Close
End If
End Select

Form1.ProgressBar1.Value = 0
Form1.ProgressBar1.Max = UBound(OniEntry)

Form1.StatusBar1.SimpleText = "OK"
'Dispose
I = Empty
NP = Empty
Erase LwoP
Erase PNTAentry
Erase OniPol2
Erase AGQGEntry
Erase AGQR_E
Erase TXMA_E
Erase TXCA_E
Erase TexNames
End Sub