#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "util.h"
#include "preferences.h"
#include "manualcommands.h"
#include "about.h"
#include "packagewizard.h"
#include "soundwizard.h"

#include <QMainWindow>
#include <QSettings>
#include <QMessageBox>
#include <QProcess>
#include <QColor>
#include <QPalette>
#include <QFileDialog>
#include <QUrl>
#include <QDesktopServices>
#include <QErrorMessage>
#include <QTextCodec>
#include <converter.h>
#include <QProgressBar>
#include <droptablewidget.h>
#include <QComboBox>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QDebug>
#include <QCloseEvent>
#include <QScriptEngine>
#include <QScriptValueIterator>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit MainWindow(QWidget *parent = 0);

    ~MainWindow();

protected:
     void closeEvent(QCloseEvent *event);
    
private slots:
    void on_actionExit_triggered();

    void on_actionAbout_triggered();

    void on_tbOni_clicked();

    void on_tbAE_clicked();

    void on_tbOpenFolder_clicked();

    void on_cbEnvMap_toggled(bool checked);

    void on_cbTexture_toggled(bool checked);

    void on_actionCheck_For_Updates_triggered();

    void on_pbAddSourceGeneral_clicked();

    void on_pbConvertGeneral_clicked();

    void TsetupProgressBar(int max);

    void TupdateProgressBar();

    void TresultConversion(QString result, int numErrors);

    void on_cbFromGeneral_currentIndexChanged(const QString &arg1);

    void on_actionWindows_triggered();

    void on_actionMac_Windows_demo_triggered();

    void on_pbClearSourcesGeneral_clicked();

    void on_pbRemoveSourceGeneral_clicked();

    void on_pbAddSourceTextures_clicked();

    void on_pbRemoveSourceTextures_clicked();

    void on_pbClearSourcesTextures_clicked();

    void on_cbFromTextures_currentIndexChanged(const QString &arg1);

    void on_cbFromModels_currentIndexChanged(const QString &arg1);

    void on_cbFromLevels_currentIndexChanged(const QString &arg1);

    void on_cbFromMisc_currentIndexChanged(const QString &arg1);

    void on_pbAddSourceModels_clicked();

    void on_pbAddSourceLevels_clicked();

    void on_pbAddSourceMisc_clicked();

    void on_pbConvertTextures_clicked();

    void on_pbConvertModels_clicked();

    void on_pbConvertLevels_clicked();

    void on_pbConvertMisc_clicked();

    void on_pbRemoveSourceModels_clicked();

    void on_pbRemoveSourceLevels_clicked();

    void on_pbRemoveSourceMisc_clicked();

    void on_pbClearSourcesModels_clicked();

    void on_pbClearSourcesLevels_clicked();

    void on_pbClearSourcesMisc_clicked();

    void on_actionPreferences_triggered();

    void on_cbToGeneral_currentIndexChanged(const QString &arg1);

    void on_cbToLevels_currentIndexChanged(const QString &arg1);

    void on_cbDatGeneral_toggled(bool checked);

    void on_cbDatLevels_toggled(bool checked);

    void on_actionCheck_OniSplit_version_triggered();

    void addFilesSource(DropTableWidget *myTable, QStringList files); //for drag 'n drop

    void dtContextMenu(DropTableWidget* myTable, QContextMenuEvent *event); //Context menu options for table widgets

    void on_cbTRAMGeneral_toggled(bool checked);

    void on_tabWidget_selected(const QString &arg1);

    void checkVagoLastVersion(QNetworkReply *result); //check vago last version

    void on_cbBnvLevels_toggled(bool checked);

    void on_cbAdditionalSourcesLevels_toggled(bool checked);

    void on_tbCommand_clicked();

    void on_actionWorkspace_triggered();

    void on_actionOther_triggered();

    void on_actionView_log_triggered();

    void on_cbToModels_currentIndexChanged(const QString &arg1);

    void on_cbWithAnimation_toggled(bool checked);

    void on_actionAE_Package_Creator_triggered();

    void on_cbFromAnimations_currentIndexChanged(const QString &arg1);

    void on_cbCamera_toggled(bool checked);

    void on_cbGeometry_toggled(bool checked);

    void on_pbConvertAnimations_clicked();

    void on_pbAddSourceAnimations_clicked();

    void on_pbRemoveSourceAnimations_clicked();

    void on_pbClearSourcesAnimations_clicked();

    void on_actionSound_Wizard_triggered();

    void on_actionCheck_xmlTools_version_triggered();

private:
    Ui::MainWindow *ui;
    Logger *myLogger;
    QString workspaceLocation; //Workspace location
    QString workspaceWizardsLocation; //Workspace wizard location
    QString outputFolder; //Output folder
    QString AeLocation; //Workspace location
    QLabel *itemsLoaded;
    QProgressBar *myBar; //Progress Bar
    QHash<QString, QString> commandMap; //Map the commands for fast retreive
    QStringList *listToProccess; //items to proccess
    Converter *myConverter;
    QSettings *vagoSettings;
    static const QString VagoSettingsName;

    void connectSlots();
    void showErrStatusMessage(QString message);
    void showSuccessStatusMessage(QString message);
    void mapCommands();
    void addRowTable(DropTableWidget *myTable,QString file, QString fromTo, QString command);
    void clearTableContents(DropTableWidget *myTable);
    void removeTableContents(DropTableWidget *myTable);
    void updateComboBox(const QString &arg1, QComboBox *comboBox, const QString &identifier);
    void startConversion(DropTableWidget *myTable);
    void updateItemsLoaded(DropTableWidget *currentTable);
    void changeToCurrentSettings(QList<int> rows, DropTableWidget* myTable); //change some rows to the current settings
    void changeItemsOutput(DropTableWidget* myTable, QList<int> rows, QString newOutput);
    QString getFileOutputFolder(QString fromTo, QString myOutputFolder="");
    QString fileParsingGeneral(QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingTextures(QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingModels(QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingAnimations(QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingLevels(QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingMisc(QString myOutputFolder, QString from, QString to , QString file);
    QString getCommand(DropTableWidget* myTable, QString myOutputFolder, QString from, QString to , QString file);
    QString getTypeConversion(DropTableWidget *myTable); //get the current type for a table
};

#endif // MAINWINDOW_H
