#include "preferences.h"
#include "ui_preferences.h"

Preferences::Preferences(QWidget *parent, QSettings *vagoSettings) :
    QDialog(parent),
    ui(new Ui::Preferences)
{
    ui->setupUi(this);
    this->setAttribute(Qt::WA_DeleteOnClose,true ); //destroy itself once finished.

    this->vagoSettings=vagoSettings;

    ui->leAEfolder->setText(this->vagoSettings->value("AeFolder").toString());
    ui->leWorkspace->setText(this->vagoSettings->value("Workspace").toString());
    ui->cbOniWindow->setChecked(this->vagoSettings->value("OniWindow").toBool());
    ui->cbSeparate->setChecked(this->vagoSettings->value("SeparateInWorkspace").toBool());
    ui->cbVagoExit->setChecked(this->vagoSettings->value("ConfirmExit").toBool());

}

Preferences::~Preferences()
{
    delete ui;
}

void Preferences::on_buttonBox_accepted()
{
    this->vagoSettings->setValue("AeFolder",ui->leAEfolder->text());
    this->vagoSettings->setValue("Workspace",ui->leWorkspace->text());
    this->vagoSettings->setValue("OniWindow",ui->cbOniWindow->isChecked());
    this->vagoSettings->setValue("SeparateInWorkspace",ui->cbSeparate->isChecked());
    this->vagoSettings->setValue("ConfirmExit",ui->cbVagoExit->isChecked());

    Util::showPopUp("You need to restart the application to all changes take effect.");
}

void Preferences::on_pbChooseWorkspace_clicked()
{
    QString newDir=QFileDialog::getExistingDirectory(this,"Choose workspace folder...");
    newDir=Util::normalizePath(newDir);

    if(!newDir.isEmpty()){
        ui->leWorkspace->setText(newDir);
    }
}

void Preferences::on_pbChooseAE_clicked()
{
    QString newDir=QFileDialog::getExistingDirectory(this,"Choose AE folder...");
    newDir=Util::normalizePath(newDir);

    if(!newDir.isEmpty()){
        ui->leAEfolder->setText(newDir);
    }
}

void Preferences::on_buttonBox_rejected()
{
    this->destroy(true,true);
}

