#include "packagepagefinal.h"
#include "ui_packagepagefinal.h"

PackagePageFinal::PackagePageFinal(QSettings *vagoSettings, QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::PackagePageFinal)
{
    ui->setupUi(this);
    this->setTitle("Finished");

    //Use the global var for the depot domain so it's easier to change in the code if the domain changes
    ui->lbComplete->setText(ui->lbComplete->text().replace("mods.oni2.net",GlobalVars::ModsDomain));

    ui->lbComplete->setOpenExternalLinks(true); //allow navigate to mod depot

    //Default checkboxes values
    if(!vagoSettings->contains("PackageCreator/OpenFolder")){
        vagoSettings->setValue("PackageCreator/OpenFolder", true);
    }
    if(!vagoSettings->contains("PackageCreator/CreateZip")){
        vagoSettings->setValue("PackageCreator/CreateZip",true);
    }

    //remember them next time
    ui->cbOpenFolder->setChecked(vagoSettings->value("PackageCreator/OpenFolder").toBool());
    ui->cbCreateZip->setChecked(vagoSettings->value("PackageCreator/CreateZip").toBool());
    registerField("cbOpenFolder", ui->cbOpenFolder);
    registerField("cbCreateZip", ui->cbCreateZip);
}

PackagePageFinal::~PackagePageFinal()
{
    delete ui;
}
