#ifndef SOUNDWIZARD_H
#define SOUNDWIZARD_H

// System includes
#include <QString>
#include <QWizard>
#include <QWizardPage>
#include <QLabel>
#include <QDesktopWidget>
#include <QVBoxLayout>
#include <QPushButton>

// Local includes
#include "util.h"
#include "logger.h"
#include "soundpage2.h"
#include "soundpage3.h"
#include "soundpage4.h"
#include "soundpagefinal.h"

class SoundWizard: public QObject // for signals and slots
{
    Q_OBJECT // for signals and slots
public:
    SoundWizard(QString workspaceWizardLocation, Logger *myLogger, QHash<QString, QString> *commandMap);
    int exec();
private:
    QWizardPage* createIntroPage();

    QString workspaceWizardLocation;
    QString soundsLocation;
    Logger *myLogger;
    QWizard *myWizard;
    QHash<QString, QString> *commandMap;
private slots:
    void restartWizard();
    void pageChanged(int pageId);
};

#endif // SOUNDWIZARD_H
