package net.oni2.aeinstaller.backend;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import net.oni2.SettingsManager;

/**
 * @author Christian Illy
 */
public class Paths {

	/**
	 * @return Mod Depot cache filename
	 */
	public static File getDepotCacheFilename() {
		return new File(getPrefsPath(), "ModDepotCache.xml");
	}

	/**
	 * @return Settings filename of AEI
	 */
	public static File getSettingsFilename() {
		return new File(getPrefsPath(), "AEI-Settings.xml");
	}

	/**
	 * Get the Jar path
	 * 
	 * @return Path
	 */
	public static File getInstallerPath() {
		if (SettingsManager.isDebug() || SettingsManager.getUseWorkingDir()) {
			String wd = System.getProperty("user.dir");
			return new File(wd);
		} else {
			String jarPath = Paths.class.getProtectionDomain().getCodeSource()
					.getLocation().getPath();
			String decodedPath = null;
			try {
				decodedPath = URLDecoder.decode(jarPath, "UTF-8");
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}
			return new File(decodedPath).getParentFile().getParentFile();
		}
	}

	/**
	 * @return Path of jar
	 */
	public static File getJarPath() {
		return new File(getInstallerPath(), "bin");
	}

	/**
	 * Get the preferences path
	 * 
	 * @return Path
	 */
	public static File getPrefsPath() {
		return getInstallerPath();
	}

	/**
	 * Get the path to store downloaded files
	 * 
	 * @return Download path
	 */
	public static File getDownloadPath() {
		return new File(getTempPath(), "downloads");
	}

	/**
	 * Get the path to store mods
	 * 
	 * @return Data path
	 */
	public static File getModsPath() {
		return new File(getInstallerPath(), "packages");
	}

	/**
	 * Get the path where vanilla .oni-files are stored
	 * 
	 * @return Vanilla .oni's path
	 */
	public static File getVanillaOnisPath() {
		return new File(getInstallerPath(), "vanilla");
	}

	/**
	 * Get the base path of Oni
	 * 
	 * @return Vanilla Oni path
	 */
	public static File getOniBasePath() {
		return getInstallerPath().getParentFile().getParentFile();
	}

	/**
	 * Get the base path of the Edition
	 * 
	 * @return Edition path
	 */
	public static File getEditionBasePath() {
		return getInstallerPath().getParentFile();
	}

	/**
	 * Get the path where the vanilla Oni GDF is located
	 * 
	 * @return Vanilla Oni GDF
	 */
	public static File getVanillaGDF() {
		return CaseInsensitiveFile.getCaseInsensitiveFile(getOniBasePath(),
				"GameDataFolder");
	}

	/**
	 * Get the path where the Edition GDF is located
	 * 
	 * @return Edition GDF
	 */
	public static File getEditionGDF() {
		return new File(getEditionBasePath(), "GameDataFolder");
	}

	/**
	 * Get the systems temp-path
	 * 
	 * @return Path
	 */
	public static File getTempPath() {
		return new File(System.getProperty("java.io.tmpdir"), "oni_aei");
	}

}
