package net.oni2.aeinstaller.backend.oni.management;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.TreeSet;

import net.oni2.aeinstaller.backend.CaseInsensitiveFile;
import net.oni2.aeinstaller.backend.Paths;
import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.platformtools.PlatformInformation;
import net.oni2.platformtools.PlatformInformation.Platform;

import org.apache.commons.io.FileUtils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.StaxDriver;

/**
 * @author Christian Illy
 */
public class ToolsManager {
	/**
	 * @return Currently installed tools
	 */
	@SuppressWarnings("unchecked")
	public static TreeSet<Integer> getInstalledTools() {
		File installCfg = new File(Paths.getInstallerPath(),
				"installed_tools.xml");
		TreeSet<Integer> res = new TreeSet<Integer>();
		try {
			if (installCfg.exists()) {
				FileInputStream fis = new FileInputStream(installCfg);
				XStream xs = new XStream(new StaxDriver());
				Object obj = xs.fromXML(fis);
				if (obj instanceof TreeSet<?>)
					res = (TreeSet<Integer>) obj;
				fis.close();
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return res;
	}

	private static void writeInstalledTools(TreeSet<Integer> tools) {
		File installCfg = new File(Paths.getInstallerPath(),
				"installed_tools.xml");
		try {
			FileOutputStream fos = new FileOutputStream(installCfg);
			XStream xs = new XStream(new StaxDriver());
			xs.toXML(tools, fos);
			fos.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @param tools
	 *            Tools to (un)install
	 * @param uninstall
	 *            Uninstall tools or install?
	 */
	public static void installTools(TreeSet<Package> tools, boolean uninstall) {
		TreeSet<Integer> installed = getInstalledTools();
		for (Package m : tools) {
			if (!uninstall || installed.contains(m.getPackageNumber())) {
				File plain = CaseInsensitiveFile.getCaseInsensitiveFile(
						m.getLocalPath(), "plain");
				if (plain.exists()) {
					if (m.hasSeparatePlatformDirs()) {
						File plainCommon = CaseInsensitiveFile
								.getCaseInsensitiveFile(plain, "common");
						File plainMac = CaseInsensitiveFile
								.getCaseInsensitiveFile(plain, "mac_only");
						File plainWin = CaseInsensitiveFile
								.getCaseInsensitiveFile(plain, "win_only");
						if (plainCommon.exists())
							copyRemoveToolsFiles(plainCommon,
									Paths.getEditionBasePath(), uninstall);
						if (PlatformInformation.getPlatform() == Platform.MACOS
								&& plainMac.exists())
							copyRemoveToolsFiles(plainMac,
									Paths.getEditionBasePath(), uninstall);
						else if (plainWin.exists())
							copyRemoveToolsFiles(plainWin,
									Paths.getEditionBasePath(), uninstall);
					} else {
						copyRemoveToolsFiles(plain, Paths.getEditionBasePath(),
								uninstall);
					}
				}
			}
			if (uninstall)
				installed.remove(m.getPackageNumber());
			else
				installed.add(m.getPackageNumber());
		}
		writeInstalledTools(installed);
	}

	private static void copyRemoveToolsFiles(File srcFolder, File targetFolder,
			boolean remove) {
		for (File f : srcFolder.listFiles()) {
			try {
				if (f.isDirectory())
					copyRemoveToolsFiles(f,
							CaseInsensitiveFile.getCaseInsensitiveFile(
									targetFolder, f.getName()), remove);
				else {
					File targetFile = CaseInsensitiveFile
							.getCaseInsensitiveFile(targetFolder, f.getName());
					if (remove) {
						if (targetFile.exists())
							targetFile.delete();
					} else {
						if (!targetFile.getName().equals(f.getName()))
							targetFile.delete();
						FileUtils.copyFileToDirectory(f, targetFolder);
						if (f.canExecute())
							CaseInsensitiveFile.getCaseInsensitiveFile(
									targetFolder, f.getName()).setExecutable(
									true);
					}
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		if (remove)
			if (targetFolder.list().length == 0)
				targetFolder.delete();
	}

}
