#include "packagepage4.h"
#include "ui_packagepage4.h"

PackagePage4::PackagePage4(QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::PackagePage4)
{
    ui->setupUi(this);
    this->setTitle("Package Files");
    this->setSubTitle("Add here the resources to the correspondent plataform for your package.");

    commonTable=ui->twCommon;
    windowsTable=ui->twWindows;
    macTable=ui->twMac;

    //Setup package resources tables
    QStringList headers = QStringList()<<"Folder"<<"Type"<<"Full Path";
    ui->twCommon->setHorizontalHeaderLabels(headers);
    ui->twCommon->setColumnWidth(1,75); //set size for type
    ui->twWindows->setHorizontalHeaderLabels(headers);
    ui->twWindows->setColumnWidth(1,75);
    ui->twMac->setHorizontalHeaderLabels(headers);
    ui->twMac->setColumnWidth(1,75);
    //

    //Set +- tooltips
    on_pbSwitchFiles_clicked();

    ui->tbCommonMinus->setToolTip("Remove the selected common OS folders");
    ui->tbWindowsMinus->setToolTip("Remove the selected Windows OS folders");
    ui->tbMacMinus->setToolTip("Remove the selected Mac OS folders");

    ui->lbCommon->setText("<html><b>Common</b></html>"); // Don't use rich text in qtdesigner because it generates platform dependent code
    ui->lbWindowsOnly->setText("<html><b>Windows Only</b></html>");
    ui->lbMacOnly->setText("<html><b>Mac OS Only</b></html>");



    connectSlots();
}

PackagePage4::~PackagePage4()
{
    delete ui;
}

void PackagePage4::on_pbSwitchFiles_clicked()
{
    if(ui->pbSwitchFiles->text()==".oni files"){
        ui->pbSwitchFiles->setText(".bsl files");
        ui->pbSwitchFiles->setToolTip("Click to add folders with .oni-patch files instead");
    }
    else if(ui->pbSwitchFiles->text()==".bsl files"){
        ui->pbSwitchFiles->setText(".oni-patch files");
        ui->pbSwitchFiles->setToolTip("Click to add folders with .oni files instead");
    }
    else{
        ui->pbSwitchFiles->setText(".oni files");
        ui->pbSwitchFiles->setToolTip("Click to add folders with .bsl files files instead");
    }

    ui->tbCommonPlus->setToolTip("Add common OS folders with "+ui->pbSwitchFiles->text());
    ui->tbWindowsPlus->setToolTip("Add Windows OS folders with "+ui->pbSwitchFiles->text());
    ui->tbMacPlus->setToolTip("Add Mac OS folders with "+ui->pbSwitchFiles->text());
}


void PackagePage4::addResourcesPackage(DropTableWidget *myTable, QStringList resources){

    //Pre-processing (check if received only folders)
    foreach(QString myFile, resources){
        if(!QDir(myFile).exists()){
            Util::showErrorPopUp("Only folders are allowed for this operation.");
            return;
        }
    }

    QString type=ui->pbSwitchFiles->text().replace(" files","");

    foreach(QString currentFolder, resources){

        currentFolder=Util::normalizePath(currentFolder); //normalize path

        //Get actual number rows
        int twSize=myTable->rowCount();

        //increase the rows for the new item
        myTable->setRowCount(twSize+1);

        //Add to table and list to
        QTableWidgetItem *newFolder = new QTableWidgetItem(Util::cutName(currentFolder));
        QTableWidgetItem *newType = new QTableWidgetItem(type);
        QTableWidgetItem *newFullPath = new QTableWidgetItem(currentFolder);

        myTable->setItem(twSize,0,newFolder);
        myTable->setItem(twSize,1,newType);
        myTable->setItem(twSize,2,newFullPath);
        myTable->updateTableToolTips(twSize); //Update tool tips
    }
}

void PackagePage4::connectSlots(){
    //Drop signal for Packages table
    connect(ui->twCommon, SIGNAL(dropped(DropTableWidget*,QStringList)), this, SLOT(addResourcesPackage(DropTableWidget*,QStringList)));
    connect(ui->twWindows, SIGNAL(dropped(DropTableWidget*,QStringList)), this, SLOT(addResourcesPackage(DropTableWidget*,QStringList)));
    connect(ui->twMac, SIGNAL(dropped(DropTableWidget*,QStringList)), this, SLOT(addResourcesPackage(DropTableWidget*,QStringList)));
}

void PackagePage4::on_tbCommonPlus_clicked()
{
   addTableContents(ui->twCommon);
}

void PackagePage4::on_tbCommonMinus_clicked()
{
    removeTableContents(ui->twCommon);
}

void PackagePage4::on_tbWindowsPlus_clicked()
{
     addTableContents(ui->twWindows);
}

void PackagePage4::on_tbWindowsMinus_clicked()
{
    removeTableContents(ui->twWindows);
}

void PackagePage4::on_tbMacPlus_clicked()
{
    addTableContents(ui->twMac);
}

void PackagePage4::on_tbMacMinus_clicked()
{
    removeTableContents(ui->twMac);
}

void PackagePage4::addTableContents(DropTableWidget *myTable){
    if(ui->pbSwitchFiles->text()==".oni files"){
        addResourcesPackage(myTable,Util::multipleDirDialog("Choose folders with .oni files..."));
    }
    else if(ui->pbSwitchFiles->text()==".bsl files"){
        addResourcesPackage(myTable,Util::multipleDirDialog("Choose folders with .bsl files..."));
    }
    else{
        addResourcesPackage(myTable,Util::multipleDirDialog("Choose folders with .oni-patch files..."));
    }
}

void PackagePage4::removeTableContents(DropTableWidget *myTable){
    int size = myTable->selectionModel()->selectedRows().size();

    if(size==0){
        Util::showPopUp("Select a row first.");
        return;
    }

    if(Util::showQuestionPopUp(this,"Are you sure you want to delete the selected rows?")){
        for(int i=0; i<size; i++){
            myTable->removeRow(myTable->selectionModel()->selectedRows().at(size-i-1).row());
        }
    }
}

bool PackagePage4::validatePage(){
    if(ui->twCommon->rowCount()==0 && ui->twWindows->rowCount()==0 && ui->twMac->rowCount()==0){
        Util::showErrorPopUp("You need to add some folders with resources first!");
        return false;
    }

    return true;
}
