//#define USING_VM_TABLET_WARNING_FIX // Comment this line if not using a mac vm

#ifdef USING_VM_TABLET_WARNING_FIX
#include <qapplication.h>
void myMessageOutput(QtMsgType type, const char *msg);
#endif

#include <QtGui/QApplication>
#include "mainwindow.h"

int main(int argc, char *argv[])
{

#ifdef USING_VM_TABLET_WARNING_FIX
    qInstallMsgHandler(myMessageOutput);
#endif

    QApplication a(argc, argv);
    MainWindow w;
    w.show();
    a.setStyleSheet("QStatusBar::item { border: 0px; }"); //hide QLabels border in status bar //http://qt-project.org/forums/viewthread/18743
    
    return a.exec();
}

#ifdef USING_VM_TABLET_WARNING_FIX
void myMessageOutput(QtMsgType type, const char *msg)
{
    switch (type) {
    case QtWarningMsg:
        if(QString(msg)=="QCocoaView handleTabletEvent: This tablet device is unknown (received no proximity event for it). Discarding event."){ // ignore this message
            return;
        }
        else{
            fprintf(stderr, "%s\n", msg);
            break;
        }
    case QtFatalMsg:
        fprintf(stderr, "%s\n", msg);
        abort();
    default:
        fprintf(stderr, "%s\n", msg);
        break;
    }
}
#endif
