UNIT Unit5_preview;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Math, ExtCtrls, Unit2_functions, Unit3_data, Unit4_exporters, Unit6_imgfuncs,
  StdCtrls, StrUtils;

TYPE
  TForm5 = Class(TForm)
    timer: TTimer;
    panel_preview: TPanel;
    img: TImage;
    panel_buttons: TPanel;
    btn_dec: TButton;
    btn_startstop: TButton;
    btn_inc: TButton;
    panel_files: TPanel;
    list: TListBox;
    panel_extension: TPanel;
    combo_extension: TComboBox;
    Splitter1: TSplitter;
    lbl_notpossible: TLabel;
    procedure FormActivate(Sender: TObject);
    PROCEDURE Recreatelist;
    PROCEDURE listClick(Sender: TObject);
    PROCEDURE PreviewTXAN;
    PROCEDURE PreviewTXMB;
    PROCEDURE PreviewTXMP;
    PROCEDURE panel_extensionResize(Sender: TObject);
    PROCEDURE combo_extensionClick(Sender: TObject);
    PROCEDURE btn_incClick(Sender: TObject);
    PROCEDURE btn_decClick(Sender: TObject);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE btn_startstopClick(Sender: TObject);
    PROCEDURE panel_buttonsResize(Sender: TObject);
    PROCEDURE timerTimer(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
  PRIVATE
  PUBLIC
  END;

VAR
  Form5: TForm5;

IMPLEMENTATION
{$R *.dfm}
USES Unit1_main;
VAR
  memstreams:Array OF TMemoryStream;
  actualimg:Byte;
  _fileid:LongWord;


PROCEDURE TForm5.Recreatelist;
  VAR
    i:LongWord;
  BEGIN
    combo_extension.Items.Clear;
    combo_extension.Items.Add('_All files_ ('+IntToStr(dat_header.Files)+')');
    FOR i:=0 TO dat_header.Extensions-1 DO BEGIN
      WITH dat_extensionsmap[i] DO BEGIN
        combo_extension.Items.Add(
          Extension[3]+Extension[2]+Extension[1]+Extension[0]+' ('+
          IntToStr(ExtCount)+')');
      END;
    END;
    combo_extension.ItemIndex:=0;
    combo_extensionClick(Self);
  END;


PROCEDURE TForm5.listClick(Sender: TObject);
  BEGIN
    _fileid:=StrToInt(MidStr(list.Items.Strings[list.ItemIndex],1,5));
    lbl_notpossible.Visible:=False;
    Self.img.Visible:=True;
    Self.timer.Enabled:=False;
    Self.panel_buttons.Visible:=False;
    Self.Caption:='Preview '+dat_files[_fileid].FileName;
    IF dat_files[_fileid].Extension='TXAN' THEN PreviewTXAN
    ELSE
    IF dat_files[_fileid].Extension='TXMB' THEN PreviewTXMB
    ELSE
    IF dat_files[_fileid].Extension='TXMP' THEN PreviewTXMP
    ELSE BEGIN
      Self.lbl_notpossible.Visible:=True;
      Self.img.Visible:=False;
    END;
  END;


PROCEDURE TForm5.panel_extensionResize(Sender: TObject);
  BEGIN
    combo_extension.Width:=panel_extension.Width-5;
  END;


PROCEDURE TForm5.combo_extensionClick(Sender: TObject);
  VAR
    Extension:String[4];
    i:LongWord;
  BEGIN
    Extension:=MidStr(combo_extension.Items.Strings[combo_extension.ItemIndex],1,4);
    list.Items.Clear;
    IF Extension='_All' THEN BEGIN
      FOR i:=0 TO dat_header.Files-1 DO
        IF (dat_files[i].FileType AND $02)=0 THEN
          list.Items.Add(dat_files[i].FileName);
    END ELSE BEGIN
      FOR i:=0 TO dat_header.Files-1 DO
        IF dat_files[i].Extension=Extension THEN
          IF (dat_files[i].FileType AND $02)=0 THEN
            list.Items.Add(dat_files[i].FileName);
    END;
  END;


PROCEDURE TForm5.PreviewTXMB;
  VAR
    data:Tdata;
    img:TImgPackage;
  BEGIN
    SetLength(memstreams,1);
    img:=LoadTXMBconnected(_fileid);
    data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);

    memstreams[0].Clear;
    memstreams[0].Write(data[0],Length(data));
    memstreams[0].Seek(0,soFromBeginning);

    Self.img.Picture.Bitmap.LoadFromStream(memstreams[0]);
  END;

PROCEDURE TForm5.PreviewTXMP;
  VAR
    data:Tdata;
    img:TImgPackage;
  BEGIN
    SetLength(memstreams,1);
    img:=LoadImgData(_fileid);
    data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);

    memstreams[0].Clear;
    memstreams[0].Write(data[0],Length(data));
    memstreams[0].Seek(0,soFromBeginning);

    Self.img.Picture.Bitmap.LoadFromStream(memstreams[0]);
  END;

PROCEDURE TForm5.PreviewTXAN;
  VAR
    loop_speed:Word;
    linkcount:LongWord;
    link:LongWord;
    i:Byte;
    data:Tdata;
    img:TImgPackage;
  BEGIN
    LoadDatFilePart(_fileid,$14,SizeOf(loop_speed),@loop_speed);
    LoadDatFilePart(_fileid,$1C,SizeOf(linkcount),@linkcount);
    SetLength(memstreams,linkcount);
    FOR i:=0 TO linkcount-1 DO BEGIN
      LoadDatFilePart(_fileid,$20+i*4,SizeOf(link),@link);
      link:=link DIV 256;
      IF link=0 THEN link:=_fileid-1;
      memstreams[i]:=TMemoryStream.Create;
      img:=LoadImgData(link);
      data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);
      memstreams[i].Clear;
      memstreams[i].Write(data[0],Length(data));
      memstreams[i].Seek(0,soFromBeginning);
    END;
    actualimg:=254;
    Self.timer.Interval:=Floor(loop_speed*(1/60)*1000);
    Self.timer.Enabled:=False;
    Self.btn_startstopClick(Self);
    Self.panel_buttons.Visible:=True;
  END;


PROCEDURE TForm5.FormCreate(Sender: TObject);
  BEGIN
    SetLength(memstreams,1);
    memstreams[0]:=TMemoryStream.Create;
    Self.Width:=260;
    Self.Height:=300;
  END;

PROCEDURE TForm5.timerTimer(Sender: TObject);
  BEGIN
    Inc(actualimg);
    IF actualimg>=Length(memstreams) THEN actualimg:=0;
    Self.img.Picture.Bitmap.LoadFromStream(memstreams[actualimg]);
    memstreams[actualimg].Seek(0,soFromBeginning);
    Self.Caption:='Preview '+dat_files[_fileid].FileName+' ('+IntToStr(actualimg+1)+'/'+IntToStr(Length(memstreams))+')';
  END;

PROCEDURE TForm5.panel_buttonsResize(Sender: TObject);
  BEGIN
    btn_startstop.Width:=panel_buttons.Width-45;
    btn_inc.Left:=panel_buttons.Width-23;
  END;

PROCEDURE TForm5.btn_startstopClick(Sender: TObject);
  BEGIN
    Self.timer.Enabled:=NOT Self.timer.Enabled;
    Self.btn_dec.Enabled:=NOT Self.timer.Enabled;
    Self.btn_inc.Enabled:=NOT Self.timer.Enabled;
    IF Self.timer.Enabled THEN
      Self.btn_startstop.Caption:='Stop automatic'
    ELSE
      Self.btn_startstop.Caption:='Start automatic';
  END;

PROCEDURE TForm5.FormResize(Sender: TObject);
  BEGIN
    IF Self.Width>=300 THEN BEGIN
    END ELSE Self.Width:=300;
    IF Self.Height>=200 THEN BEGIN
    END ELSE Self.Height:=200;
  END;

PROCEDURE TForm5.btn_decClick(Sender: TObject);
  BEGIN
    IF actualimg>0 THEN
      Dec(actualimg)
    ELSE
      actualimg:=High(memstreams);
    Self.Caption:='Preview '+dat_files[_fileid].FileName+' ('+IntToStr(actualimg+1)+'/'+IntToStr(Length(memstreams))+')';
    Self.img.Picture.Bitmap.LoadFromStream(memstreams[actualimg]);
    memstreams[actualimg].Seek(0,soFromBeginning);
  END;

PROCEDURE TForm5.btn_incClick(Sender: TObject);
  BEGIN
    IF actualimg<High(memstreams) THEN
      Inc(actualimg)
    ELSE
      actualimg:=0;
    Self.Caption:='Preview '+dat_files[_fileid].FileName+' ('+IntToStr(actualimg+1)+'/'+IntToStr(Length(memstreams))+')';
    Self.img.Picture.Bitmap.LoadFromStream(memstreams[actualimg]);
    memstreams[actualimg].Seek(0,soFromBeginning);
  END;


PROCEDURE TForm5.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    Action:=caFree;
    Form1.close_window(Self.Name);
  END;


PROCEDURE TForm5.FormActivate(Sender: TObject);
  BEGIN
    Form1.SetActiveWindow(Self.Name);
  END;

END.
