UNIT Unit5_preview;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Math, ExtCtrls, Unit2_functions, Unit3_data, Unit4_exporters, Unit6_imgfuncs,
  StdCtrls;

TYPE
  TForm5 = Class(TForm)
    img: TImage;
    timer: TTimer;
    panel_buttons: TPanel;
    btn_dec: TButton;
    btn_startstop: TButton;
    btn_inc: TButton;
    PROCEDURE btn_incClick(Sender: TObject);
    PROCEDURE btn_decClick(Sender: TObject);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE btn_startstopClick(Sender: TObject);
    PROCEDURE panel_buttonsResize(Sender: TObject);
    PROCEDURE timerTimer(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    PROCEDURE ShowPreview(fileid:LongWord);
  PRIVATE
  PUBLIC
  END;

VAR
  Form5: TForm5;

IMPLEMENTATION
{$R *.dfm}
USES Unit1_main;
VAR
  memstreams:Array OF TMemoryStream;
  actualimg:Byte;
  _fileid:LongWord;

PROCEDURE PreviewTXMB;
  VAR
    data:Tdata;
    img:TImgPackage;
  BEGIN
    SetLength(memstreams,1);
    img:=LoadTXMBconnected(_fileid);
    data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);

    memstreams[0].Clear;
    memstreams[0].Write(data[0],Length(data));
    memstreams[0].Seek(0,soFromBeginning);

    Form5.img.Picture.Bitmap.LoadFromStream(memstreams[0]);
  END;

PROCEDURE PreviewTXMP;
  VAR
    data:Tdata;
    img:TImgPackage;
  BEGIN
    SetLength(memstreams,1);
    img:=LoadImgData(_fileid);
    data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);

    memstreams[0].Clear;
    memstreams[0].Write(data[0],Length(data));
    memstreams[0].Seek(0,soFromBeginning);

    Form5.img.Picture.Bitmap.LoadFromStream(memstreams[0]);
  END;

PROCEDURE PreviewTXAN;
  VAR
    loop_speed:Word;
    linkcount:LongWord;
    link:LongWord;
    i:Byte;
    data:Tdata;
    img:TImgPackage;
  BEGIN
    LoadDatFilePart(_fileid,$14,SizeOf(loop_speed),@loop_speed);
    LoadDatFilePart(_fileid,$1C,SizeOf(linkcount),@linkcount);
    SetLength(memstreams,linkcount);
    FOR i:=0 TO linkcount-1 DO BEGIN
      LoadDatFilePart(_fileid,$20+i*4,SizeOf(link),@link);
      link:=link DIV 256;
      IF link=0 THEN link:=_fileid-1;
      memstreams[i]:=TMemoryStream.Create;
      img:=LoadImgData(link);
      data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);
      memstreams[i].Clear;
      memstreams[i].Write(data[0],Length(data));
      memstreams[i].Seek(0,soFromBeginning);
    END;
    actualimg:=254;
    Form5.timer.Interval:=Floor(loop_speed*(1/60)*1000);
    Form5.timer.Enabled:=False;
    Form5.btn_startstopClick(Form5); 
    Form5.panel_buttons.Visible:=True;
  END;

PROCEDURE TForm5.ShowPreview(fileid:LongWord);
  BEGIN
    _fileid:=fileid;
    Form5.timer.Enabled:=False;
    Form5.panel_buttons.Visible:=False;
    Form5.Caption:='Preview '+dat_files[_fileid].FileName;
    IF dat_files[fileid].Extension='TXAN' THEN PreviewTXAN;
    IF dat_files[fileid].Extension='TXMB' THEN PreviewTXMB;
    IF dat_files[fileid].Extension='TXMP' THEN PreviewTXMP;
  END;

PROCEDURE TForm5.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    CanClose:=False;
    Form5.Visible:=False;
  END;

PROCEDURE TForm5.FormCreate(Sender: TObject);
  BEGIN
    SetLength(memstreams,1);
    memstreams[0]:=TMemoryStream.Create;
    Form5.Width:=170;
    Form5.Height:=200;
  END;

PROCEDURE TForm5.timerTimer(Sender: TObject);
  BEGIN
    Inc(actualimg);
    IF actualimg>=Length(memstreams) THEN actualimg:=0;
    Form5.img.Picture.Bitmap.LoadFromStream(memstreams[actualimg]);
    memstreams[actualimg].Seek(0,soFromBeginning);
    Form5.Caption:='Preview '+dat_files[_fileid].FileName+' ('+IntToStr(actualimg+1)+'/'+IntToStr(Length(memstreams))+')';
  END;

PROCEDURE TForm5.panel_buttonsResize(Sender: TObject);
  BEGIN
    btn_startstop.Width:=panel_buttons.Width-45;
    btn_inc.Left:=panel_buttons.Width-23;
  END;

PROCEDURE TForm5.btn_startstopClick(Sender: TObject);
  BEGIN
    Form5.timer.Enabled:=NOT Form5.timer.Enabled;
    Form5.btn_dec.Enabled:=NOT Form5.timer.Enabled;
    Form5.btn_inc.Enabled:=NOT Form5.timer.Enabled;
    IF Form5.timer.Enabled THEN
      Form5.btn_startstop.Caption:='Stop automatic'
    ELSE
      Form5.btn_startstop.Caption:='Start automatic';
  END;

PROCEDURE TForm5.FormResize(Sender: TObject);
  BEGIN
    IF Form5.Width>=150 THEN BEGIN
    END ELSE Form5.Width:=150;
    IF Form5.Height>=150 THEN BEGIN
    END ELSE Form5.Height:=150;
  END;

PROCEDURE TForm5.btn_decClick(Sender: TObject);
  BEGIN
    IF actualimg>0 THEN
      Dec(actualimg)
    ELSE
      actualimg:=High(memstreams);
    Form5.Caption:='Preview '+dat_files[_fileid].FileName+' ('+IntToStr(actualimg+1)+'/'+IntToStr(Length(memstreams))+')';
    Form5.img.Picture.Bitmap.LoadFromStream(memstreams[actualimg]);
    memstreams[actualimg].Seek(0,soFromBeginning);
  END;

PROCEDURE TForm5.btn_incClick(Sender: TObject);
  BEGIN
    IF actualimg<High(memstreams) THEN
      Inc(actualimg)
    ELSE
      actualimg:=0;
    Form5.Caption:='Preview '+dat_files[_fileid].FileName+' ('+IntToStr(actualimg+1)+'/'+IntToStr(Length(memstreams))+')';
    Form5.img.Picture.Bitmap.LoadFromStream(memstreams[actualimg]);
    memstreams[actualimg].Seek(0,soFromBeginning);
  END;

END.
