UNIT Unit1_main;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, Clipbrd, ExtCtrls, ComCtrls, Menus, Grids,
  MPHexEditor, ToolWin, ImgList, Tabs,
  Unit2_functions, Unit3_data, Unit9_data_structures,
  Unit10_leveldb, Unit4_exporters,
  Unit5_preview, Unit7_txmpreplace, Unit8_binedit, Unit11_extractor, Unit13_rawedit;

TYPE
  TForm1 = Class(TForm)
    tabs: TTabSet;
    saved: TSaveDialog;
    opend: TOpenDialog;
    statbar: TStatusBar;
    menu: TMainMenu;
    menu_main: TMenuItem;
    menu_loaddat: TMenuItem;
    menu_lvldb: TMenuItem;
    menu_exit: TMenuItem;
    menu_convert: TMenuItem;
    menu_createdb: TMenuItem;
    menu_createlvl: TMenuItem;
    menu_tools: TMenuItem;
    menu_preview: TMenuItem;
    menu_txmpreplace: TMenuItem;
    menu_binedit: TMenuItem;
    menu_extractor: TMenuItem;
    menu_windows: TMenuItem;
    menu_windows_cascade: TMenuItem;
    menu_windows_tile: TMenuItem;
    menu_windows_closeall: TMenuItem;
    menu_windows_next: TMenuItem;
    menu_windows_previous: TMenuItem;
    menu_sep1: TMenuItem;
    menu_sep2: TMenuItem;
    menu_sep3: TMenuItem;
    menu_levelstructedit: TMenuItem;
    menu_rawedit: TMenuItem;
    menu_filecompare: TMenuItem;
    ClosefileDB1: TMenuItem;
    PROCEDURE ClosefileDB1Click(Sender: TObject);
    PROCEDURE menu_filecompareClick(Sender: TObject);
    PROCEDURE menu_raweditClick(Sender: TObject);
    PROCEDURE menu_createlvlClick(Sender: TObject);
    PROCEDURE menu_extractorClick(Sender: TObject);
    PROCEDURE menu_lvldbClick(Sender: TObject);
    PROCEDURE menu_createdbClick(Sender: TObject);
    PROCEDURE SetActiveWindow(window_name:String);
    PROCEDURE tabsChange(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
    PROCEDURE close_window(window_name:String);
    PROCEDURE menu_windows_previousClick(Sender: TObject);
    PROCEDURE menu_windows_nextClick(Sender: TObject);
    PROCEDURE menu_windows_tileClick(Sender: TObject);
    FUNCTION open_child(window_context:String):Boolean;
    PROCEDURE menu_windows_closeallClick(Sender: TObject);
    PROCEDURE menu_windows_cascadeClick(Sender: TObject);
    PROCEDURE menu_window_entryClick(Sender: TObject);
    PROCEDURE menu_bineditClick(Sender: TObject);
    PROCEDURE menu_loaddatClick(Sender: TObject);
    PROCEDURE menu_txmpreplaceClick(Sender: TObject);
    PROCEDURE menu_exitClick(Sender: TObject);
    PROCEDURE menu_previewClick(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
  PRIVATE
  PUBLIC
  END;

VAR
  Form1: TForm1;

IMPLEMENTATION
{$R *.dfm}
VAR
  tablist:Array OF String;

PROCEDURE TForm1.FormCreate(Sender: TObject);
  BEGIN
    Form1.Caption:='Oni Un/Packer '+version;
    Form1.FormResize(Form1);

    IF FileExists(ExtractFilepath(Application.EXEname)+'\oniunpacker.ini') THEN BEGIN
      AssignFile(AppSettingsFile,ExtractFilepath(Application.EXEname)+'\oniunpacker.ini');
      Reset(AppSettingsFile);
      Read(AppSettingsFile,AppSettings);
      CloseFile(AppSettingsFile);
    END ELSE BEGIN
      AppSettings.DatPath:='D:\Spiele\Oni\GameDataFolder';
      AppSettings.ExtractPath:='C:\Dokumente und Einstellungen\Administrator\Desktop';
    END;
    LoadStructureDefinitions(ExtractFilepath(Application.EXEname)+'\StructDefs');
  END;

PROCEDURE TForm1.FormResize(Sender: TObject);
  CONST
    MinWidth:Integer=750;
    MinHeight:Integer=500;
  BEGIN
    IF Form1.Width<MinWidth THEN Form1.Width:=MinWidth;
    IF Form1.Height<MinHeight THEN Form1.Height:=MinHeight;
    Form1.statbar.Panels.Items[0].Width:=Form1.Width-200;
  END;

PROCEDURE TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    AssignFile(AppSettingsFile,ExtractFilepath(Application.EXEname)+'\oniunpacker.ini');
    IF FileExists(ExtractFilepath(Application.EXEname)+'\oniunpacker.ini') THEN
      Reset(AppSettingsFile)
    ELSE
      Rewrite(AppSettingsFile);
    Write(AppSettingsFile,AppSettings);
    CloseFile(AppSettingsFile);
    Action:=caFree;
  END;


{#################################}
{##### Main-Menu-Handlers    #####}
{#################################}
PROCEDURE TForm1.menu_loaddatClick(Sender: TObject);
  VAR i:LongWord;
  BEGIN
    opend.InitialDir:=AppSettings.DatPath;
    opend.Filter:='Oni-Dat-Files|*.dat';
    IF opend.Execute THEN BEGIN
      menu_windows_closeallClick(Form1);
      IF Length(tablist)=0 THEN BEGIN
        IF opened_state=opened_db THEN CloseDatabase;
        Caption:='Oni Un/Packer '+version;
        statbar.Panels.Items[0].Text:='Nothing loaded';
        statbar.Panels.Items[1].Text:='Files: -';
        statbar.Panels.Items[2].Text:='Extensions: -';
        AppSettings.DatPath:=ExtractFilepath(opend.FileName);
        IF LoadDatInfos(opend.FileName) THEN BEGIN
          Form1.Caption:='Oni Un/Packer '+version+' ('+ExtractFileName(opend.FileName)+')';
          statbar.Panels.Items[0].Text:='.dat loaded: '+dat_FileName;
          statbar.Panels.Items[1].Text:='Files: '+IntToStr(dat_header.Files);
          statbar.Panels.Items[2].Text:='Extensions: '+IntToStr(dat_header.Extensions);
          menu_tools.Enabled:=True;
          menu_convert.Enabled:=False;
        END ELSE BEGIN
          menu_convert.Enabled:=True;
          ShowMessage('Error while loading the file:'+CrLf+opend.FileName+CrLf+'Perhaps not an Oni-.dat-file?');
        END;
      END;
    END;
  END;
PROCEDURE TForm1.menu_lvldbClick(Sender: TObject);
  BEGIN
    opend.InitialDir:=AppSettings.DatPath;
    opend.Filter:='OUP-Level-DB (*.oldb)|*.oldb';
    IF opend.Execute THEN BEGIN
      menu_windows_closeallClick(Form1);
      IF Length(tablist)=0 THEN BEGIN
        IF opened_state=opened_db THEN CloseDatabase;
        Form1.Caption:='Oni Un/Packer '+version;
        opened_state:=opened_nothing;
        statbar.Panels.Items[0].Text:='Nothing loaded';
        statbar.Panels.Items[1].Text:='Files: -';
        statbar.Panels.Items[2].Text:='Extensions: -';
        OpenDatabase(opend.FileName);
        IF opened_state=opened_db THEN BEGIN
          menu_tools.Enabled:=True;
          menu_convert.Enabled:=False;
          statbar.Panels.Items[0].Text:='OLDB loaded: '+opend.FileName;
          statbar.Panels.Items[1].Text:='Files: '+IntToStr(Length(GetFilesList('','',False)));
          statbar.Panels.Items[2].Text:='Extensions: '+IntToStr(Length(GetExtensionsList));
        END ELSE BEGIN
          menu_tools.Enabled:=False;
          menu_convert.Enabled:=True;
        END;
      END;
    END;
  END;
PROCEDURE TForm1.ClosefileDB1Click(Sender: TObject);
  BEGIN
    menu_windows_closeallClick(Form1);
    IF Length(tablist)=0 THEN BEGIN
      IF opened_state=opened_db THEN CloseDatabase;
      Form1.Caption:='Oni Un/Packer '+version;
      opened_state:=opened_nothing;
      statbar.Panels.Items[0].Text:='Nothing loaded';
      statbar.Panels.Items[1].Text:='Files: -';
      statbar.Panels.Items[2].Text:='Extensions: -';
      menu_tools.Enabled:=False;
      menu_convert.Enabled:=True;
    END;
  END;
PROCEDURE TForm1.menu_exitClick(Sender: TObject);
  BEGIN
    Form1.Close;
  END;

{####################################}
{##### Converters-Menu-Handlers #####}
{####################################}
PROCEDURE TForm1.menu_createdbClick(Sender: TObject);
  BEGIN
    opend.Filter:='Oni-Dat-Files|*.dat';
    saved.Filter:='OUP-Level-DB (*.oldb)|*.oldb';
    saved.DefaultExt:='oldb';
    IF opend.Execute THEN BEGIN
      IF saved.Execute THEN BEGIN
        Form10.CreateDatabase(opend.FileName,saved.FileName);
      END;
    END;
  END;
PROCEDURE TForm1.menu_createlvlClick(Sender: TObject);
  BEGIN
    opend.Filter:='OUP-Level-DB (*.oldb)|*.oldb';
    saved.Filter:='Oni-Dat-Files|*.dat';
    saved.DefaultExt:='dat';
    IF opend.Execute THEN BEGIN
      IF saved.Execute THEN BEGIN
        Form10.CreateLevel(opend.FileName,saved.FileName);
      END;
    END;
  END;

{#################################}
{##### Tools-Menu-Handlers   #####}
{#################################}
PROCEDURE TForm1.menu_previewClick(Sender: TObject);
  BEGIN
    open_child('preview');
  END;
PROCEDURE TForm1.menu_txmpreplaceClick(Sender: TObject);
  BEGIN
    open_child('txmpreplace');
  END;
PROCEDURE TForm1.menu_bineditClick(Sender: TObject);
  BEGIN
    open_child('binedit');
  END;
PROCEDURE TForm1.menu_raweditClick(Sender: TObject);
  BEGIN
    open_child('rawedit');
  END;
PROCEDURE TForm1.menu_extractorClick(Sender: TObject);
  BEGIN
    open_child('extractor');
  END;
PROCEDURE TForm1.menu_filecompareClick(Sender: TObject);
  BEGIN
    open_child('compare');
  END;


{#################################}
{#####  Window-Menu-Handlers #####}
{#################################}
PROCEDURE TForm1.menu_windows_cascadeClick(Sender: TObject);
  BEGIN
    Form1.Cascade;
  END;
PROCEDURE TForm1.menu_windows_tileClick(Sender: TObject);
  BEGIN
    Form1.TileMode:=tbHorizontal;
    Form1.Tile;
  END;
PROCEDURE TForm1.menu_windows_closeallClick(Sender: TObject);
  VAR
    i:Byte;
  BEGIN
    IF MDIChildCount>0 THEN BEGIN
      FOR i:=0 TO MDIChildCount-1 DO BEGIN
        MDIChildren[i].Close;
      END;
    END;
    tabs.Tabs.Clear;
  END;
PROCEDURE TForm1.menu_windows_nextClick(Sender: TObject);
  VAR i:Byte;
    first_window:Byte;
    current_focus:String;
  BEGIN
    IF MDIChildCount>1 THEN BEGIN
      FOR i:=0 TO menu_windows.Count-1 DO BEGIN
        IF Pos('menu_window_',menu_windows.Items[i].Name)=1 THEN BEGIN
          first_window:=i;
          Break;
        END;
      END;
      current_focus:=ActiveMDIChild.Name;
      FOR i:=first_window TO menu_windows.Count-1 DO
        IF Pos(current_focus,menu_windows.Items[i].Name)>0 THEN
          Break;
      IF i=menu_windows.Count-1 THEN
        menu_windows.Items[first_window].Click
      ELSE
        menu_windows.Items[i+1].Click;
      FOR i:=0 TO High(tablist) DO BEGIN
        IF tablist[i]=ActiveMDIChild.Name THEN BEGIN
          tabs.TabIndex:=i;
        END;
      END;
    END;
  END;
PROCEDURE TForm1.menu_windows_previousClick(Sender: TObject);
  VAR i:Byte;
    first_window:Byte;
    current_focus:String;
  BEGIN
    IF MDIChildCount>1 THEN BEGIN
      FOR i:=0 TO menu_windows.Count-1 DO BEGIN
        IF Pos('menu_window_',menu_windows.Items[i].Name)=1 THEN BEGIN
          first_window:=i;
          Break;
        END;
      END;
      current_focus:=ActiveMDIChild.Name;
      FOR i:=first_window TO menu_windows.Count-1 DO
        IF Pos(current_focus,menu_windows.Items[i].Name)>0 THEN
          Break;
      IF i=first_window THEN
        menu_windows.Items[menu_windows.Count-1].Click
      ELSE
        menu_windows.Items[i-1].Click;
      FOR i:=0 TO High(tablist) DO BEGIN
        IF tablist[i]=ActiveMDIChild.Name THEN BEGIN
          tabs.TabIndex:=i;
        END;
      END;
    END;
  END;

PROCEDURE TForm1.menu_window_entryClick(Sender: TObject);
  VAR
    i:Byte;
    window_name:String;
  BEGIN
    window_name:=MidStr(TComponent(Sender).Name,Pos('window_',TComponent(Sender).Name)+7,Length(TComponent(Sender).Name)-Pos('window_',TComponent(Sender).Name)+7+1);
    FOR i:=0 TO MDIChildCount-1 DO BEGIN
      IF MDIChildren[i].Name=window_name THEN BEGIN
        MDIChildren[i].BringToFront;
      END;
    END;
    FOR i:=0 TO High(tablist) DO BEGIN
      IF tablist[i]=ActiveMDIChild.Name THEN BEGIN
        tabs.TabIndex:=i;
      END;
    END;
  END;



FUNCTION TForm1.open_child(window_context:String):Boolean;
  VAR
    rawEdit:TForm13;
    binEdit:TForm8;
    preview:TForm5;
    txmpreplacer:TForm7;
    extractor:TForm11;
    menu_button:TMenuItem;
    used:Array[1..9] OF Boolean;
    i:Byte;
    caption:String;
    name:String;
  BEGIN
    Result:=True;
    FOR i:=1 TO 9 DO used[i]:=False;
    IF MDIChildCount>0 THEN
      FOR i:=0 TO MDIChildCount-1 DO
        IF Pos(window_context,Form1.MDIChildren[i].Name)=1 THEN
          used[StrToInt(RightStr(Form1.MDIChildren[i].Caption,1))]:=True;
    FOR i:=1 TO 10 DO
      IF i=10 THEN
        Break
      ELSE
        IF NOT used[i] THEN Break;

    IF i<10 THEN BEGIN
      name:=window_context+IntToStr(i);
      IF window_context='binedit' THEN
        caption:='Binary .dat-Editor '+IntToStr(i);
      IF window_context='rawedit' THEN
        caption:='Binary .raw-Editor '+IntToStr(i);
      IF window_context='preview' THEN
        caption:='Preview-Window '+IntToStr(i);
      IF window_context='txmpreplace' THEN
        caption:='TXMP Replacer '+IntToStr(i);
      IF window_context='extractor' THEN
        caption:='Extractor '+IntToStr(i);

      menu_button:=TMenuItem.Create(menu_windows);
      menu_button.Caption:=caption;
      menu_button.Name:='menu_window_'+name;
      menu_button.OnClick:=Form1.menu_window_entryClick;
      menu_windows.Add(menu_button);

      SetLength(tablist,Length(tablist)+1);
      tablist[High(tablist)]:=name;
      tabs.Tabs.Add(caption);

      IF window_context='binedit' THEN BEGIN
        binEdit:=TForm8.Create(Application);
        binEdit.Name:=name;
        binEdit.Caption:=caption;
        binEdit.Recreatelist;
      END;
      IF window_context='rawedit' THEN BEGIN
        rawEdit:=TForm13.Create(Application);
        rawEdit.Name:=name;
        rawEdit.Caption:=caption;
        rawEdit.Recreatelist;
      END;
      IF window_context='preview' THEN BEGIN
        preview:=TForm5.Create(Application);
        preview.Name:=name;
        preview.Caption:=caption;
        preview.Recreatelist;
      END;
      IF window_context='txmpreplace' THEN BEGIN
        txmpreplacer:=TForm7.Create(Application);
        txmpreplacer.Name:=name;
        txmpreplacer.Caption:=caption;
        txmpreplacer.Recreatelist;
      END;
      IF window_context='extractor' THEN BEGIN
        extractor:=TForm11.Create(Application);
        extractor.Name:=name;
        extractor.Caption:=caption;
        extractor.Recreatelist;
      END;

      tabs.TabIndex:=High(tablist);
      IF MDIChildCount=9 THEN menu_tools.Enabled:=False;
    END ELSE BEGIN
      Result:=False;
    END;
  END;


PROCEDURE TForm1.close_window(window_name:String);
  VAR
    i,j:Byte;
  BEGIN
    FOR i:=0 TO menu_windows.Count-1 DO BEGIN
      IF menu_windows.Items[i].Name='menu_window_'+window_name THEN BEGIN
        menu_windows.Items[i].Free;
        Break;
      END;
    END;
    FOR i:=0 TO High(tablist) DO BEGIN
      IF tablist[i]=window_name THEN BEGIN
        tabs.Tabs.Delete(i);
        IF High(tablist)>0 THEN
          FOR j:=i TO High(tablist)-1 DO
            tablist[j]:=tablist[j+1];
        SetLength(tablist,Length(tablist)-1);
        Break;
      END;
    END;
    menu_tools.Enabled:=True;
  END;


PROCEDURE TForm1.tabsChange(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
  VAR
    i:Byte;
  BEGIN
    FOR i:=0 TO MDIChildCount-1 DO BEGIN
      IF MDIChildren[i].Name=tablist[NewTab] THEN
        MDIChildren[i].BringToFront;
    END;
  END;

PROCEDURE TForm1.SetActiveWindow(window_name:String);
  VAR
    i:Byte;
  BEGIN
    IF Length(tablist)>0 THEN
      FOR i:=0 TO High(tablist) DO
        IF tablist[i]=window_name THEN
          tabs.TabIndex:=i;
  END;


END.
