#include "logger.h"

Logger::Logger(QString appDir)
{
     myLogFile = new QFile(appDir+"/"+GlobalVars::AppLogName);

     if (!myLogFile->open(QIODevice::WriteOnly | QIODevice::Text)){ //open to write
           return;
     }

    logStream = new QTextStream (myLogFile);
    //logStream->setCodec("UTF-8");
}

 /**
  ** Mutex makes it thread safe. (not sure if needed although)
  **/
void Logger::writeString(QString strToWrite){
    mutex.lock();
    *this->logStream << "--------------------------------------------";
    *this->logStream << "\nEvent Start: " << QDateTime::currentDateTime().toString() << "\n" << strToWrite << "\nEvent End.\n";
    *this->logStream << "--------------------------------------------\n";
    this->logStream->flush();
    mutex.unlock();
}

/**
 ** Mutex makes it thread safe. (not sure if needed although)
 **/
void Logger::writeBytes(QByteArray arrToWrite){
   mutex.lock();
   *this->logStream << "--------------------------------------------";
   *this->logStream << "\nEvent Start: " << QDateTime::currentDateTime().toString() << "\n" << arrToWrite << "\nEvent End.\n";
   *this->logStream << "--------------------------------------------";
   this->logStream->flush();
   mutex.unlock();
}

//deconstructor, will close the file automatically and free the resources...
Logger::~Logger(){
    delete this->logStream;
    delete this->myLogFile; //the deconstructor of the file will close it automatically
}
