package net.oni2.aeinstaller.gui.modtable;

import javax.swing.RowFilter;

import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.aeinstaller.backend.packages.Type;

/**
 * @author Christian Illy
 */
public class ModTableFilter extends RowFilter<ModTableModel, Integer> {
	private Type type = null;
	private int downloadState = 0;
	private EApplyFilterTo filterTo = EApplyFilterTo.ALL;
	private String filterString = null;

	private boolean showCorePackages = false;
	private boolean showInvalidPlatform = false;

	/**
	 * @param type
	 *            Type of mods to show (null for all)
	 * @param downloadState
	 *            Show only: 0 = all, 1 = online, 2 = downloaded, 3 = installed
	 * @param filterString
	 *            Filter for the given string
	 * @param filterTo
	 *            Use the string filter only on the named field
	 * @param showCorePackages
	 *            Show core packages in table
	 * @param showInvalidPlatform
	 *            Show packages not valid on this platform
	 */
	public ModTableFilter(Type type, int downloadState, String filterString,
			EApplyFilterTo filterTo, boolean showCorePackages,
			boolean showInvalidPlatform) {
		super();
		this.type = type;
		this.downloadState = downloadState;
		if (filterString != null)
			this.filterString = filterString.toLowerCase();
		this.filterTo = filterTo;
		this.showCorePackages = showCorePackages;
		this.showInvalidPlatform = showInvalidPlatform;
	}

	@Override
	public boolean include(
			RowFilter.Entry<? extends ModTableModel, ? extends Integer> entry) {
		Package mod = (Package) entry.getModel().getValueAt(
				entry.getIdentifier(), -1);

		if (mod.isCorePackage() && !showCorePackages)
			return false;

		if (!mod.isValidOnPlatform() && !showInvalidPlatform)
			return false;

		boolean result = true;
		if (type != null)
			result &= mod.getTypes().contains(type);
		switch (downloadState) {
			case 1:
				result &= !mod.isLocalAvailable();
				break;
			case 2:
				result &= mod.isLocalAvailable();
				break;
			case 3:
				result &= mod.isInstalled();
				break;
		}
		if (filterString != null && filterString.length() > 1) {
			switch (filterTo) {
				case ALL:
					result &= mod.getName().toLowerCase()
							.contains(filterString)
							|| mod.getCreator().toLowerCase()
									.contains(filterString)
							|| mod.getDescription().toLowerCase()
									.contains(filterString);
					break;
				case CREATOR:
					result &= mod.getCreator().toLowerCase()
							.contains(filterString);
					break;
				case DESCRIPTION:
					result &= mod.getDescription().toLowerCase()
							.contains(filterString);
					break;
				case NAME:
					result &= mod.getName().toLowerCase()
							.contains(filterString);
					break;
			}
		}

		return result;
	}
}
