#ifndef DROPTABLEWIDGET_H
#define DROPTABLEWIDGET_H

#include <QTableWidget>
#include <QtGui>

#include "util.h"


//Used in swapPositions function, for switching orders and maintain the disabled style
struct tableRowProperties{ //No need for typedef in c++ :)
    QStringList cells;
    bool isDisabled;

    tableRowProperties(){
        cells = QStringList(); //initialize the list on the constructor
        isDisabled=false; //if you don't initialize a variable at c++ it is random assigned!
    }
};

class QMimeData;

class DropTableWidget : public QTableWidget {

    Q_OBJECT

public:
    DropTableWidget(QWidget *parent = 0,
                    QBrush _disabledBackStyle = QPalette().brush(QPalette::Disabled,QPalette::Base),
                    QBrush _disabledTextStyle = QPalette().brush(QPalette::Disabled,QPalette::WindowText));

    const QBrush disabledBackStyle;
    const QBrush disabledTextStyle;

    void swapPositions(QList<int> rowsSelected, int numUnitsToMove);
    void resetStyleWidgetItem(QTableWidgetItem *currentItem);
    void setDisableStyleWidgetItem(QTableWidgetItem *currentItem);
    void updateTableToolTips(int row);
    QString getFileAbsolute(int row);
    QString getOutputAbsolute(int row);

public slots:
    void clear();

signals:
    void changed(const QMimeData *mimeData = 0);
    void dropped(DropTableWidget *myTable, QStringList pathList);
    QString getTypeConversion(DropTableWidget *thisTable);
    void changeToCurrentSettings(int rows[], DropTableWidget* thisTable);
    void dtContextMenu(DropTableWidget* thisTable, QContextMenuEvent *event);

protected:
    void dragEnterEvent(QDragEnterEvent *event);
    void dragMoveEvent(QDragMoveEvent *event);
    void dragLeaveEvent(QDragLeaveEvent *event);
    void dropEvent(QDropEvent *event);
    void contextMenuEvent(QContextMenuEvent * event);

private:
    QTableWidget *tablewidget;
};

#endif // DROPTABLEWIDGET_H
