#ifndef PACKAGEWIZARD_H
#define PACKAGEWIZARD_H

#include "logger.h"
#include "packagepage2.h"
#include "packagepage3.h"
#include "packagepage4.h"
#include "packagepagefinal.h"
#include "zip.h"

#include <QLabel>
#include <QVBoxLayout>
#include <QLineEdit>
#include <QRect>
#include <QDesktopWidget>
#include <QTextStream>
#include <QSettings>

class PackageWizard
{
public:
    PackageWizard(QString workspaceWizardLocation,QSettings *vagoSettings, Logger *myLogger);
    int exec();
private:
    QWizardPage *createIntroPage();
    void copyPackageFolders(const DropTableWidget *myTable, QString tableDir, QString modDir, bool &bslExist);
    void createPackage(const QWizard &myWizard, PackagePage4 *page4);
    void checkForZipError(Zip::ErrorCode ec);

    Logger *myLogger;
    QString workspaceWizardLocation;
    QString packagesLocation;
    QSettings *vagoSettings;
};

#endif // PACKAGEWIZARD_H
