#ifndef MANUALCOMMANDS_H
#define MANUALCOMMANDS_H

#include <QMainWindow>
#include <QClipboard>
#include <QProcess>
#include <QScrollBar>

#include "util.h"


namespace Ui {
class ManualCommands;
}

class ManualCommands : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit ManualCommands(QWidget *parent = 0);
    ~ManualCommands();

protected:
    bool eventFilter(QObject* obj, QEvent *event);
    
private slots:
    void on_pbInput_clicked();

    void on_pcCopyClipboard_clicked();

    void on_pbClear_clicked();

private:
    void executeCommand();
    Ui::ManualCommands *ui;
    static const int limHistory=50;
    QString history[limHistory]; //this is kinda a circular buffer manual implementation (http://www.boost.org/doc/libs/1_36_0/libs/circular_buffer/doc/circular_buffer.html)
    int nextInsertHistoryIdx; //next index where new commands will be inserted
    int searchHistoryIdx; //current index when searching history with arrows
    QProcess *myProcess;
};

#endif // MANUALCOMMANDS_H
