/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.peer.SystemTrayPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import sun.awt.AppContext;
import sun.awt.HeadlessToolkit;
import sun.awt.SunToolkit;
import sun.security.util.SecurityConstants;

public class SystemTray {
    private static SystemTray systemTray;
    private int currentIconID = 0;
    private transient SystemTrayPeer peer;

    private SystemTray() {
        this.addNotify();
    }

    public static SystemTray getSystemTray() {
        SystemTray.checkSystemTrayAllowed();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        SystemTray.initializeSystemTrayIfNeeded();
        if (!SystemTray.isSupported()) {
            throw new UnsupportedOperationException("The system tray is not supported on the current platform.");
        }
        return systemTray;
    }

    public static boolean isSupported() {
        if (Toolkit.getDefaultToolkit() instanceof HeadlessToolkit) {
            return ((HeadlessToolkit)Toolkit.getDefaultToolkit()).isTraySupported();
        }
        if (Toolkit.getDefaultToolkit() instanceof SunToolkit) {
            SystemTray.initializeSystemTrayIfNeeded();
            return ((SunToolkit)Toolkit.getDefaultToolkit()).isTraySupported();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TrayIcon trayIcon) throws AWTException {
        if (trayIcon == null) {
            throw new NullPointerException("adding null TrayIcon");
        }
        TrayIcon[] trayIconArray = null;
        TrayIcon[] trayIconArray2 = null;
        Vector<TrayIcon> vector = null;
        SystemTray systemTray = this;
        synchronized (systemTray) {
            trayIconArray = SystemTray.systemTray.getTrayIcons();
            vector = (Vector<TrayIcon>)AppContext.getAppContext().get(TrayIcon.class);
            if (vector == null) {
                vector = new Vector<TrayIcon>(3);
                AppContext.getAppContext().put(TrayIcon.class, vector);
            } else if (vector.contains(trayIcon)) {
                throw new IllegalArgumentException("adding TrayIcon that is already added");
            }
            vector.add(trayIcon);
            trayIconArray2 = SystemTray.systemTray.getTrayIcons();
            trayIcon.setID(++this.currentIconID);
        }
        try {
            trayIcon.addNotify();
        }
        catch (AWTException aWTException) {
            vector.remove(trayIcon);
            throw aWTException;
        }
        this.firePropertyChange("trayIcons", trayIconArray, trayIconArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TrayIcon trayIcon) {
        if (trayIcon == null) {
            return;
        }
        TrayIcon[] trayIconArray = null;
        TrayIcon[] trayIconArray2 = null;
        SystemTray systemTray = this;
        synchronized (systemTray) {
            trayIconArray = SystemTray.systemTray.getTrayIcons();
            Vector vector = (Vector)AppContext.getAppContext().get(TrayIcon.class);
            if (vector == null || !vector.remove(trayIcon)) {
                return;
            }
            trayIcon.removeNotify();
            trayIconArray2 = SystemTray.systemTray.getTrayIcons();
        }
        this.firePropertyChange("trayIcons", trayIconArray, trayIconArray2);
    }

    public TrayIcon[] getTrayIcons() {
        Vector vector = (Vector)AppContext.getAppContext().get(TrayIcon.class);
        if (vector != null) {
            return vector.toArray(new TrayIcon[vector.size()]);
        }
        return new TrayIcon[0];
    }

    public Dimension getTrayIconSize() {
        return this.peer.getTrayIconSize();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.getCurrentChangeSupport().addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.getCurrentChangeSupport().removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.getCurrentChangeSupport().getPropertyChangeListeners(string);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        this.getCurrentChangeSupport().firePropertyChange(string, object, object2);
    }

    private synchronized PropertyChangeSupport getCurrentChangeSupport() {
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)AppContext.getAppContext().get(SystemTray.class);
        if (propertyChangeSupport == null) {
            propertyChangeSupport = new PropertyChangeSupport(this);
            AppContext.getAppContext().put(SystemTray.class, propertyChangeSupport);
        }
        return propertyChangeSupport;
    }

    synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = ((SunToolkit)Toolkit.getDefaultToolkit()).createSystemTray(this);
        }
    }

    static void checkSystemTrayAllowed() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.ACCESS_SYSTEM_TRAY_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSystemTrayIfNeeded() {
        Class<SystemTray> clazz = SystemTray.class;
        synchronized (SystemTray.class) {
            if (systemTray == null) {
                systemTray = new SystemTray();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

