package net.oni2.aeinstaller.gui.packageinfobox;

import java.awt.Insets;
import java.util.ResourceBundle;

import javax.swing.JLabel;
import javax.swing.JPanel;

import net.oni2.aeinstaller.backend.SizeFormatter;
import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.aeinstaller.backend.packages.Type;
import net.oni2.aeinstaller.gui.HTMLLinkLabel;
import net.oni2.resourcebundle.UTF8ResourceBundleLoader;

import org.javabuilders.BuildResult;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class PackageInfoBox extends JPanel {
	private static final long serialVersionUID = 233098603653577693L;

	private ResourceBundle bundle = UTF8ResourceBundleLoader
			.getBundle("net.oni2.aeinstaller.localization."
					+ getClass().getSimpleName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private JLabel lblTitleVal;
	private JLabel lblCreatorVal;
	private JLabel lblTypesVal;
	private JLabel lblPlatformVal;
	private JLabel lblPackageNumberVal;
	private JLabel lblVersionNumberVal;
	private HTMLLinkLabel lblDescriptionVal;
	private JLabel lblDownloadSizeVal;

	/**
	 * Create a package info box
	 */
	public PackageInfoBox() {
		super();
		lblDescriptionVal.setMargin(new Insets(-15, 0, 0, 0));
	}

	/**
	 * @param mod
	 *            Mod info to show
	 */
	public void updateInfo(Package mod) {
		lblTitleVal.setText("");
		lblCreatorVal.setText("");
		lblDescriptionVal.setText("");
		lblTypesVal.setText("");
		lblPlatformVal.setText("");
		lblPackageNumberVal.setText("");
		lblVersionNumberVal.setText("");
		lblDownloadSizeVal.setText("");

		if (mod != null) {
			lblTitleVal.setText("<html>" + mod.getName() + "</html>");
			lblCreatorVal.setText("<html>" + mod.getCreator() + "</html>");
			lblDescriptionVal.setText(mod.getDescription());

			String types = "";
			for (Type t : mod.getTypes()) {
				if (types.length() > 0)
					types += ", ";
				types += t.getName();
			}
			lblTypesVal.setText("<html>" + types + "</html>");
			lblPlatformVal.setText(mod.getPlatform().toString());
			lblPackageNumberVal.setText(mod.getPackageNumberString());
			lblVersionNumberVal.setText(mod.getVersion());
			lblDownloadSizeVal
					.setText(SizeFormatter.format(mod.getZipSize(), 3));
		}
	}
}
