package net.oni2.aeinstaller.gui.modtable;

import java.util.ResourceBundle;

import net.oni2.resourcebundle.UTF8ResourceBundleLoader;

/**
 * @author Christian Illy
 */
public enum EApplyFilterTo {
	/**
	 * Filter on all fields
	 */
	ALL,
	/**
	 * Filter only on name field
	 */
	NAME,
	/**
	 * Filter only on creator field
	 */
	CREATOR,
	/**
	 * Filter only on description field
	 */
	DESCRIPTION;

	private ResourceBundle bundle = UTF8ResourceBundleLoader
			.getBundle("net.oni2.aeinstaller.localization.ModTable");

	/**
	 * @return Name of Filter
	 */
	public String toString() {
		return bundle.getString("filterTo." + super.toString());
	}

}
