package net.oni2.aeinstaller.gui.packageinfobox;

import java.util.ResourceBundle;

import javax.swing.JPanel;

import net.oni2.aeinstaller.backend.SizeFormatter;
import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.aeinstaller.backend.packages.Type;
import net.oni2.resourcebundle.UTF8ResourceBundleLoader;
import net.oni2.swingcomponents.HTMLLinkLabel;

import org.javabuilders.BuildResult;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class PackageInfoBox extends JPanel {
	private static final long serialVersionUID = 233098603653577693L;

	private ResourceBundle bundle = UTF8ResourceBundleLoader
			.getBundle("net.oni2.aeinstaller.localization."
					+ getClass().getSimpleName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private HTMLLinkLabel lblTitleVal;
	private HTMLLinkLabel lblCreatorVal;
	private HTMLLinkLabel lblTypesVal;
	private HTMLLinkLabel lblPlatformVal;
	private HTMLLinkLabel lblPackageNumberVal;
	private HTMLLinkLabel lblVersionNumberVal;
	private HTMLLinkLabel lblDescriptionVal;
	private HTMLLinkLabel lblDownloadSizeVal;

	/**
	 * Create a package info box
	 */
	public PackageInfoBox() {
		super();
		lblTitleVal.enableBorder(false);
		lblCreatorVal.enableBorder(false);
		lblTypesVal.enableBorder(false);
		lblPlatformVal.enableBorder(false);
		lblPackageNumberVal.enableBorder(false);
		lblVersionNumberVal.enableBorder(false);
		lblDownloadSizeVal.enableBorder(false);
	}

	/**
	 * @param mod
	 *            Mod info to show
	 */
	public void updateInfo(Package mod) {
		lblTitleVal.setText("");
		lblCreatorVal.setText("");
		lblDescriptionVal.setText("");
		lblTypesVal.setText("");
		lblPlatformVal.setText("");
		lblPackageNumberVal.setText("");
		lblVersionNumberVal.setText("");
		lblDownloadSizeVal.setText("");

		if (mod != null) {
			lblTitleVal.setText(mod.getName());
			lblCreatorVal.setText(mod.getCreator());
			lblDescriptionVal.setText(mod.getDescription());

			String types = "";
			for (Type t : mod.getTypes()) {
				if (types.length() > 0)
					types += ", ";
				types += t.getName();
			}
			lblTypesVal.setText(types);
			lblPlatformVal.setText(mod.getPlatform().toString());
			lblPackageNumberVal.setText(mod.getPackageNumberString());
			lblVersionNumberVal.setText(mod.getVersion());
			lblDownloadSizeVal
					.setText(SizeFormatter.format(mod.getZipSize(), 3));
		}
	}
}
