package net.oni2.aeinstaller.updater.backend;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * @author Christian Illy
 */
public class Paths {

	/**
	 * Use the wd instead of the jar path
	 */
	public static boolean useWorkingDirectory = false;

	/**
	 * Get the Jar path
	 * 
	 * @return Path
	 */
	public static File getInstallerPath() {
		String jarPath = Paths.class.getProtectionDomain().getCodeSource()
				.getLocation().getPath();
		String decodedPath = null;
		try {
			decodedPath = URLDecoder.decode(jarPath, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return new File(decodedPath).getParentFile();
	}

	/**
	 * @return Proxy settings filename of AEI
	 */
	public static File getProxySettingsFilename() {
		return new File(getPrefsPath(), "AEI-ProxySettings.xml");
	}

	/**
	 * Get the preferences path
	 * 
	 * @return Path
	 */
	public static File getPrefsPath() {
		if (useWorkingDirectory) {
			String wd = System.getProperty("user.dir");
			return new File(wd);
		} else
			return getInstallerPath();
	}

	/**
	 * Get the path to store downloaded files
	 * 
	 * @return Download path
	 */
	public static File getDownloadPath() {
		return new File(getTempPath(), "downloads");
	}

	/**
	 * Get the systems temp-path
	 * 
	 * @return Path
	 */
	public static File getTempPath() {
		return new File(System.getProperty("java.io.tmpdir"), "oni_aei");
	}

}
