package net.oni2.aeinstaller.backend;


/**
 * @author Christian Illy
 */
public class RuntimeOptions {
	private static boolean debugRun = false;
	private static boolean useWorkingDir = false;
	private static boolean offlineMode = false;
	private static boolean noCacheUpdate = false;

	/**
	 * @param debug
	 *            Debug mode
	 */
	public static void setDebug(boolean debug) {
		debugRun = debug;
	}

	/**
	 * @return Is debug run
	 */
	public static boolean isDebug() {
		return debugRun;
	}

	/**
	 * @param useWd
	 *            Use working directory instead of jar path
	 */
	public static void setUseWorkingDir(boolean useWd) {
		useWorkingDir = useWd;
	}

	/**
	 * @return Do we want to use working directory
	 */
	public static boolean getUseWorkingDir() {
		return useWorkingDir;
	}

	/**
	 * @return Is offline?
	 */
	public static boolean isOfflineMode() {
		return offlineMode;
	}

	/**
	 * @param offline
	 *            Is offline?
	 */
	public static void setOfflineMode(boolean offline) {
		offlineMode = offline;
	}

	/**
	 * @return Is in noCacheUpdate mode?
	 */
	public static boolean isNoCacheUpdateMode() {
		return noCacheUpdate;
	}

	/**
	 * @param noCacheUpd
	 *            Is in noCacheUpdate mode?
	 */
	public static void setNoCacheUpdateMode(boolean noCacheUpd) {
		noCacheUpdate = noCacheUpd;
	}

}
