unit Data;

interface

uses Classes, Graphics;

const
  Version: String   = 'v0.34a';
  DBVersion: String = '0.3';
  CrLf: String[2]   = #13 + #10;

type
  TData = array of Byte;

  THeader = packed record
    Ident:      array[0..$13] of Byte;
    Files:      LongWord;
    NamedFiles: LongWord;
    Extensions: LongWord;
    DataAddr:   LongWord;
    DataSize:   LongWord;
    NamesAddr:  LongWord;
    NamesSize:  LongWord;
    Ident2:     array[0..$F] of Byte;
  end;
  TFilesMap = array of packed record
    Extension: array[0..$3] of Char;
    DataAddr:  LongWord;
    NameAddr:  LongWord;
    FileSize:  LongWord;
    FileType:  LongWord;
  end;

  TFileInfo = packed record
    ID:      Integer;
    FileName: String;
    FileNameHex: String;
    Extension: String[4];
    Name:    String;
    Size:    LongWord;
    FileType: LongWord;
    DatAddr: LongWord;
    opened:  Boolean;
  end;
  TFiles = array of TFileInfo;

  TNamedFilesMap = array of packed record
    FileNumber: LongWord;
    blubb:      LongWord;
  end;
  TExtensionsMap = array of packed record
    Ident:     array[0..$7] of Byte;
    Extension: array[0..$3] of Char;
    ExtCount:  LongWord;
  end;

  TLevelInfo = record
    Ident: array[0..$13] of Byte;
    LevelNumber: Byte;
  end;

  TAppSettings = record
    DatPath:     String[250];
    ExtractPath: String[250];
    FilenumbersAsHex: Boolean;
    CharSet:     TFontCharSet;
    HideUnusedData: Boolean;
  end;

  TStringArray = array of String;
  TExtList     = array of record
    Ext:   String;
    Count: LongWord;
  end;

  TRawInfo = record
    src_id:     LongWord;
    src_offset: LongWord;
    raw_addr:   LongWord;
    raw_size:   LongWord;
    loc_sep:    Boolean;
  end;
  TRawList = array of TRawInfo;

  TDatLinks = array of record
    Src_Offset: LongWord;
    Target:     LongWord;
  end;

  TToolList = array of record
    context: String;
    name: String;
    exts: String;
  end;

  TSortType = (stIDAsc, stIDDesc, stNameAsc, stNameDesc, stExtAsc, stExtDesc);

var
{
  opened_state:Byte=0;
  dat_filename:String='';
  raw_filename:String='';
  dat_os_mac:Boolean=False;
  dat_header:Theader;
  dat_filesmap:Tfilesmap;
  dat_files:Tfiles;
  dat_namedfilesmap:Tnamedfilesmap;
  dat_extensionsmap:Textensionsmap;
}
  AppSettings:     TAppSettings;
  AppSettingsFile: file of TAppSettings;
{
  database_level:LongWord;
  database_ident:Array[0..$13] of Byte;
}
const
{  header_ident1_pc:Array[0..$13] of Byte=
      ($1F,$27,$DC,$33,$DF,$BC,$03,$00,$31,$33,$52,$56,$40,$00,$14,$00,$10,$00,$08,$00);
  header_ident1_mac:Array[0..$13] of Byte=
      ($61,$30,$C1,$23,$DF,$BC,$03,$00,$31,$33,$52,$56,$40,$00,$14,$00,$10,$00,$08,$00);
  header_ident2:Array[0..$F] of Byte=
      ($99,$CF,$40,$00,$90,$4F,$63,$00,$F4,$55,$5F,$00,$90,$4F,$63,$00);
}
  export_noerror: Integer = 0;
  export_nohandler: Integer = 1;
  export_handlererror: Integer = 2;
  export_error: Integer = 3;
{
  opened_nothing:Byte=0;
  opened_dat:Byte=1;
  opened_db:Byte=2;
}
implementation

end.
