package net.oni2.aeinstaller.backend;

/**
 * @author Christian Illy
 */
public class SizeFormatter {
	/**
	 * @param sizeVal
	 *            Size in Byte
	 * @param digits
	 *            Number of digits
	 * @return Formatted value
	 */
	public static String format(long sizeVal, int digits) {
		String names[] = { "B", "KiB", "MiB", "GiB", "TiB" };
		int nameInd = 0;
		float size = sizeVal;
		while ((size > 1024) && (nameInd < (names.length - 1))) {
			nameInd++;
			size /= 1024;
		}
		if (size < 10)
			return String.format(
					"%1." + String.valueOf(Math.max(digits - 1, 0)) + "f %s",
					size, names[nameInd]);
		else if (size < 100)
			return String.format(
					"%1." + String.valueOf(Math.max(digits - 2, 0)) + "f %s",
					size, names[nameInd]);
		else
			return String.format(
					"%1." + String.valueOf(Math.max(digits - 3, 0)) + "f %s",
					size, names[nameInd]);
	}
}
