#include "Flatline.h"
#include "../Oni_Symbols.h"
#include <assert.h>

#define FLAG_AND_INCREMENT( FLAG )	PD->UpdateFlags |= (1 << FLAG ); DataPointer += FLpData_PartSize( FLAG );

void FLsPacketBuild( uint8_t p, PlayerData* PD, bool UpdateAll )
{
	Character* Player = PlayerList[p]->Chr;
	ActiveCharacter* APlayer = ONrGetActiveCharacter(Player);
	player_info * PI = PlayerList[p];
	uint8_t * DataPointer = PD->data;
	PD->ID = p;
	
	//if ( data has changed )
	//{
	//	copy it to the buffer
	//  copy it to the player info
	//  set the changed flag
	//  increment the buffer pointer
	//}

	/* 
	//Could probably send this every frame, but afk players can save a few bytes, eh?
	if( PI->Input.Actions1 != PI->InputFromClient.Actions1 ||
		PI->Input.Actions2 != PI->InputFromClient.Actions2 ||
		PI->Input.MouseDeltaX != PI->InputFromClient.MouseDeltaX ||
		PI->Input.MouseDeltaY != PI->InputFromClient.MouseDeltaY )
	{*/

	//Better in case of dropped packets to send input every frame
	if(1)
	{
		memcpy( DataPointer, &PI->InputFromClient, sizeof(PlayerInput));
		PI->Input = PI->InputFromClient;

		FLAG_AND_INCREMENT( PFlag_Input );
	}

	if( PI->Facings.Facing != Player->Facing ||
		PI->Facings.DesiredFacing != Player->DesiredFacing || UpdateAll )
	{
		PlayerFacing* ptr = (void*)DataPointer;
		ptr->Facing = Player->Facing;
		ptr->DesiredFacing = Player->DesiredFacing;

		PI->Facings = *ptr;

		FLAG_AND_INCREMENT( PFlag_Facing );
	}

	if(PI->Health.Health != Player->Health ||
		PI->Health.MaxHealth != Player->MaxHealth || UpdateAll )
	{
		PlayerHealth* ptr = (void*)DataPointer;
		ptr->Health = Player->Health;
		ptr->MaxHealth = Player->MaxHealth;

		PI->Health = *ptr;

		FLAG_AND_INCREMENT( PFlag_Health );
	}

	//Score
	//skipping for now

	//Frame and ping can be sent every frame, i guess. Improve this later,
	if( 1 )
	{
		PlayerFP* ptr = (void*)DataPointer;
		if(APlayer)
		{
			ptr->Frame = APlayer->Frame;
		}
		else
		{
			ptr->Frame = -1;
		}
		ptr->Ping = PI->Ping;

		PI->Frame = ptr->Frame;

		FLAG_AND_INCREMENT( PFlag_FramePing );
	}
	
	//Skipping inventory because we dont need it right now
	if( 0 )
	{
		//Do inventory
	}

	if( PI->Class != Player->ONCC || UpdateAll )
	{
		snprintf( DataPointer, 32, "%s", TMrInstance_GetInstanceName( Player->ONCC ) );
		snprintf( PI->ClassString, 32, "%s", DataPointer );
		PI->Class = Player->ONCC;

		FLAG_AND_INCREMENT( PFlag_Class );
	}

	if(APlayer)
	{
		if( (APlayer->PhyContext) && (memcmp(&PI->Position, &APlayer->PhyContext->Position, sizeof(Vector3)) || UpdateAll ))
		{
			Vector3* ptr = (Vector3*)DataPointer;
			*ptr = PI->Position = APlayer->PhyContext->Position;
		
			FLAG_AND_INCREMENT( PFlag_Position );
		}

		if(APlayer->Animation != PI->Animation || !APlayer->Frame || UpdateAll )
		{
			snprintf( DataPointer, 32, "%s", TMrInstance_GetInstanceName( APlayer->Animation ) );
			snprintf( PI->AnimationString, 32, "%s", DataPointer );
			PI->Animation = APlayer->Animation;

			
			FLAG_AND_INCREMENT( PFlag_Animation );
		}

		if(APlayer->targetThrow)
		{
			if(!PI->HasAppliedThrow || UpdateAll )
			{
				PlayerThrowData* ptr = (void*)DataPointer;
				ptr->throwing = Players[APlayer->throwing].list_slot;
				memcpy(ptr->throwName, TMrInstance_GetInstanceName(APlayer->targetThrow), 31);
				ptr->throwFrame = ONrGetActiveCharacter(APlayer->targetThrow)->Frame;

				PI->ThrowData = *ptr;

				PI->HasAppliedThrow = 1;

				FLAG_AND_INCREMENT( PFlag_Throws );
			}
		}
		else
		{
			PI->HasAppliedThrow = 0;
		}
	}
	
	PD->Size = (uint32_t)DataPointer - (uint32_t)PD;

	PI->UpdateFlags = PD->UpdateFlags;	
	
}



void FLsSendPlayerData()
{
	PlayerData BuildData[32] = {0};
	uint8_t p = 0;
	uint32_t PacketSize = 0;
	flatline_packet OutputPacket = {0};
	uint8_t* OutputPointer = OutputPacket.data;
	//Most of the time we won't even hit this. Could probably be bumped up a few hundred bytes
	const uint32_t max_packet_size = 1000;

	//Prepare buffers
	OutputPacket.id = PK_PLAYER_DATA;
	memset( BuildData, 0, sizeof(PlayerData) * 32 );

	//Build data
	for(p = 0; p < MAX_PLAYERS; p++)
	{
		if(PlayerList[p] && PlayerList[p]->Chr)
		{
			FLsPacketBuild(p, &BuildData[p], 0);
			
			assert( BuildData[p].Size < 255 );
			
			if( BuildData[p].Size > 0 )
			{

				//If we hit maximum size, send the packet and reset the buffer for a new one
				if( BuildData[p].Size + PacketSize > max_packet_size )
				{
					UDPServer_SendToAll(&OutputPacket, PacketSize + FLATLINE_HEADER);

					memset( OutputPacket.data, 0, PacketSize );
					OutputPointer = OutputPacket.data;
					PacketSize = 0;
				}

				//add to the packet
				memcpy( OutputPointer, &BuildData[p], BuildData[p].Size );

				OutputPointer += BuildData[p].Size;
				PacketSize += BuildData[p].Size;
			}
		}
	}
	//Send data
	if( PacketSize > 0 )
	{
		UDPServer_SendToAll(&OutputPacket, PacketSize + FLATLINE_HEADER);
	}
}
