#include "Objt.h"
#include "../Daodan.h"
#include "../Oni_Symbols.h"

void DD_OBJiTriggerVolume_Draw(OBJtObject *inObject, uint32_t inDrawFlags)
{
	uint32_t itr;
	OBJtOSD_All* inOSD = (OBJtOSD_All*) inObject->object_data;
	OBJtOSD_TriggerVolume *trigger_osd = &inOSD->osd.trigger_volume_osd;
	M3tPoint3D* points = trigger_osd->volume.worldPoints;
	M3tPoint3D trigger_center = MUgZeroPoint;
	uint32_t shade = 0xFFFFFF;
	UUtBool is_selected = ((inDrawFlags & OBJcDrawFlag_Selected) != 0);

	if (!OBJgTriggerVolume_Visible) {
		return;
	}

	if (OBJrTriggerVolume_IntersectsCharacter(inObject, trigger_osd->team_mask, ONgGameState->local.playerCharacter)) {
		shade = IMcShade_Red;
	}
	else if (is_selected)
	{
		shade = IMcShade_Green;
	}
	else
	{
		shade = IMcShade_Blue;
	}

	M3rGeom_Line_Light(points + 0, points + 1, shade);
	M3rGeom_Line_Light(points + 1, points + 3, shade);
	M3rGeom_Line_Light(points + 3, points + 2, shade);
	M3rGeom_Line_Light(points + 2, points + 0, shade);

	M3rGeom_Line_Light(points + 4, points + 5, shade);
	M3rGeom_Line_Light(points + 5, points + 7, shade);
	M3rGeom_Line_Light(points + 7, points + 6, shade);
	M3rGeom_Line_Light(points + 6, points + 4, shade);

	M3rGeom_Line_Light(points + 0, points + 4, shade);
	M3rGeom_Line_Light(points + 1, points + 5, shade);
	M3rGeom_Line_Light(points + 3, points + 7, shade);
	M3rGeom_Line_Light(points + 2, points + 6, shade);

	if (is_selected) {
		M3rGeom_Line_Light(points + 0, points + 3, shade);
		M3rGeom_Line_Light(points + 1, points + 2, shade);

		M3rGeom_Line_Light(points + 4, points + 7, shade);
		M3rGeom_Line_Light(points + 5, points + 6, shade);

		M3rGeom_Line_Light(points + 2, points + 4, shade);
		M3rGeom_Line_Light(points + 1, points + 7, shade);
		M3rGeom_Line_Light(points + 0, points + 6, shade);
		M3rGeom_Line_Light(points + 3, points + 5, shade);

		M3rGeom_Line_Light(points + 2, points + 7, shade);
		M3rGeom_Line_Light(points + 3, points + 6, shade);
		M3rGeom_Line_Light(points + 0, points + 5, shade);
		M3rGeom_Line_Light(points + 1, points + 4, shade);
	}

	trigger_center = MUgZeroPoint;
	for(itr = 0; itr < M3cNumBoundingPoints; itr++)
	{
		MUmVector_Add(trigger_center, trigger_center, points[itr]);
	}

	MUmVector_Scale(trigger_center, (1.0f / ((float) M3cNumBoundingPoints)));
}

void DD_OBJiFlag_Draw(OBJtObject *inObject, uint32_t inDrawFlags)
{
	OBJtOSD_Flag			*flag_osd;
	M3tPoint3D				camera_location;
	
	M3tPoint3D points[4] = 
	{
		{ 0.0f,  0.0f,  0.0f },
		{ 0.0f, 10.0f,  0.0f },
		{ 0.0f,  8.0f,  4.0f },
		{ 0.0f,  6.0f,  0.0f }
	};
	
	if (OBJgFlag_DrawFlags == UUcFalse) { return; }
	
	// get a pointer to the object osd
	flag_osd = (OBJtOSD_Flag*)inObject->object_data;
	
	if ((OBJgFlag_ViewPrefix != 0) && (OBJgFlag_ViewPrefix != flag_osd->id_prefix)) { return; }
	
	// set up the matrix stack
	M3rMatrixStack_Push();
	M3rMatrixStack_ApplyTranslate(inObject->position);
	M3rMatrixStack_Multiply(&flag_osd->rotation_matrix);
	M3rGeom_State_Commit();
	
	// draw the flag
	M3rGeom_Line_Light(points + 0, points + 1, flag_osd->shade);
	M3rGeom_Line_Light(points + 1, points + 2, flag_osd->shade);
	M3rGeom_Line_Light(points + 2, points + 3, flag_osd->shade);
	
	// draw the name
	camera_location = CArGetLocation();
	if (MUrPoint_Distance(&inObject->position, &camera_location) < OBJgFlag_DrawNameDistance)
	{
		OBJiFlag_DrawName(inObject, points + 1);
	}
	
	// draw the rotation ring if this flag is selected
	if (inDrawFlags & OBJcDrawFlag_Selected)
	{
		M3tBoundingSphere	bounding_sphere;
		
		OBJrObject_GetBoundingSphere(inObject, &bounding_sphere);
		OBJrObjectUtil_DrawRotationRings(inObject, &bounding_sphere, OBJcDrawFlag_RingY);
	}

	M3rMatrixStack_Pop();
}

