package net.oni2.aeinstaller.backend;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataSource;

/**
 * @author Christian Illy
 */
public class StringDataSource implements DataSource {

	private String str;

	/**
	 * Create a SDS from the given string
	 * 
	 * @param str
	 *            String to represent
	 */
	public StringDataSource(String str) {
		this.str = str;
	}

	@Override
	public String getContentType() {
		return "text/plain";
	}

	@Override
	public InputStream getInputStream() throws IOException {
		return new ByteArrayInputStream(str.getBytes());
	}

	@Override
	public String getName() {
		return "<unknown>";
	}

	@Override
	public OutputStream getOutputStream() throws IOException {
		throw new IOException("Can not write to the string data source");
	}

}
