#ifndef BFW_MOTOKO_DRAW_H
#define BFW_MOTOKO_DRAW_H

typedef struct M3tDisplayMode
{
	unsigned short Width;
	unsigned short Height;
	unsigned short Depth;
	unsigned short __unused;
} M3tDisplayMode;						// 0x0010: (size).

typedef struct M3tDisplayDevice
{
	unsigned int __unknown;				// 
	unsigned short NumModes;			// 0x0004: number of valid display modes on this device.
	M3tDisplayMode Modes[16];			// 0x0006: list of supported display modes.
	unsigned short __padding;			// 0x0086: padding (not used).
} M3tDisplayDevice;						// 0x0088: (size).
 
typedef struct M3tDrawEngineCaps
{
	int Type;							// 0x0000:
	char Name[64];						// 0x0004: draw engine name (eg. "OpenGL").
	char Driver[64];					// 0x0044: driver name (always NULL string).
	unsigned int Version;				// 0x0084: draw engine version (1 for OpenGL).
	unsigned int NumDevices;			// 0x0088: number of valid DisplayDevice-s.
	M3tDisplayDevice DisplayDevices[8];	// 0x008c: 1 or more display devices.
	int __unknown;						// 0x04cc:
} M3tDrawEngineCaps;					// 0x04d0: (size).

typedef struct
{
	int Context_New;
	int Context_Delete;
	int Texture_ResetAll;
	int PrivateState_Size;
	int PrivateState_New;
	int PrivateState_Delete;
	int State_Update;
} M3tDrawEngine;

typedef struct
{
	int FrameStart;
	int FrameEnd;
	int FrameSync;
	int Triangle;
	int Quad;
	int Pent;
	int Line;
	int Point;
	int TriSprite;
	int Sprite;
	int SpriteArray;
	int ScreenCapture;
	int PointVisible;
	int SupportsPointVisible;
	int TextureFormatAvailable;
	int SetResolution;
	int ResetFog;
	int TextureLoad;
	int TextureUnload;
	int SinglePassMultitextureCapable;
} M3tDrawContext;

typedef struct
{
	float *Position;
	int *Color;
	float *TexCoord0;
	float *TexCoord1;
	void *Texture0;
	void *Texture1;
	void *State6;
	void *State7;
	void *State8;
} M3tDrawPtrState;

typedef struct
{
	WORD data[3][256];
} M3tWin32GammaRamp;

typedef struct
{
	float	x;
	float	y;
	float	z;
	float	invW;
} M3tPointScreen;

typedef struct
{
	char pad[8];
		
	UUtUns16 width;
	UUtUns16 height;
	int texelType; // enum IMtPixelType
		
	UUtUns16 num_x;
	UUtUns16 num_y;

	UUtUns32 num_textures;
	void* textures[1]; // struct M3tTextureMap
} M3tTextureMap_Big;

extern char M3gResolutionSwitch;

#endif
