#ifndef CONVERTER_H
#define CONVERTER_H
#include <QProcess>
#include <QProgressBar>
#include <QThread>

#include "logger.h"

class Converter : public QThread
{
     Q_OBJECT
public:
    Converter(QString AppDir, Logger *myLogger, QStringList *myData);
private:
    QString AppDir;
    Logger *myLogger;
    QStringList *myData;
    QProcess *myProcess;
    bool processHasKilled;

protected:
    void run(); //for thread
private slots:
    void terminateCurrProcess();
signals:
    void setupPB(int numberTasks);
    void taskDone();
    void resultConversion(QString result, int numErrors);
    void conversionAborted();
};



#endif // CONVERTER_H
