#ifndef UTIL_H
#define UTIL_H

#include <QString>
#include <QMessageBox>
#include <QFileDialog>
#include <QListView>
#include <QTreeView>
#include <QDesktopServices>
#include <QUrl>
#include <QCoreApplication>
#include <QDesktopWidget>

namespace GlobalVars{
const QString AppVersion="0.9";
const QString OniSplitString="OniSplit.exe";
const QString XmlToolsString="xmlTools.exe";

#ifdef Q_WS_WIN
const QString OniExe="Oni.exe";
const QString OniSplitExeName=OniSplitString;
const QString XmlToolsExeName=XmlToolsString;
#else
const QString OniExe="Oni.app/Contents/MacOS/Oni";
const QString OniSplitExeName="mono "+OniSplitString; // Mac uses mono to run .net applications
const QString XmlToolsExeName="mono "+XmlToolsString;
#endif

const QString AppLogName="logVago.txt";
const QString BuiltOniSplitVersion="0.9.94.0";
const QString BuiltXmlToolsVersion="0.8d";
const QString ModsDomain="mods.oni2.net";
const QString VagoNode = "247";
const QString VagoCheckUpdatesUrl="http://"+ModsDomain+"/?q=api/node/"+VagoNode+".json";
const QString VagoWebUrl="http://"+ModsDomain+"/node/"+VagoNode;
const QString VagoTemporaryDir=QDir::tempPath()+"/VagoTemp";
const QString HelpDir="help";
const int DefaultWindowWidth=800;
const int DefaultWindowHeight=600;
const char OniSplitProcSeparator=';';
}

/**
  Utilities functions (global)
  **/
namespace Util{
QString normalizePath(QString path);
QString cutName(QString path);
QString insertQuotes(QString path);
QString normalizeAndQuote(QString path);
QString fullTrim(QString str);
QString normalizeDecimalSeparator(QString value);

QStringList multipleDirDialog(QString title);
QStringList substring(QString myString,QString separator,Qt::CaseSensitivity cs = Qt::CaseSensitive);
int indexOfBackward(QString myString, QString toSearch, int from = -1);
bool showQuestionPopUp(QWidget * parent, QString message);
bool checkEmptySpaces(QStringList toCheck);
bool checkIfIntegers(QStringList toCheck);
bool checkIfDoubles(QStringList toCheck);
bool isStringInteger(QString myString);
bool isStringDouble(QString myString);
bool cpDir(const QString &srcPath, const QString &dstPath);
bool rmDir(const QString &dirPath);
bool removeDir(const QString &dirName);
QRect getScreenResolution();
void showPopUp(QString message);
void showRichPopUp(QString message);
void showWarningPopUp(QString message);
void showErrorPopUp(QString message);
void showErrorLogPopUp(QString message);
void showRichErrorPopUp(QString message);
void openLogFile();
}

#endif // UTIL_H
