#include "converter.h"

Converter::Converter(QString AppDir, Logger *myLogger, QStringList *myData)
{
    this->AppDir=AppDir;
    this->myLogger=myLogger;
    this->myData=myData;
}

void Converter::run()
{
    this->processHasKilled=false;
    this->myProcess = new QProcess();
    QString result = QString();
    QString errorMessage = "";
    int numErrors=0;

    myProcess->setWorkingDirectory(this->AppDir); // Set working directory (for work with AEI2/Mac OS)

    if(this->myData->size()!=1){
        emit setupPB(this->myData->size());
    }
    else{
        emit setupPB(0); //Intermitent bar, we don't have any estimation when the task is done
    }

    for(int i=0; i<this->myData->size(); i++){

        QString commands=this->myData->at(i);
        QString commandToExec;

        int currentIndex=0, nextIndex=0;

        while(true){
            nextIndex=commands.indexOf(GlobalVars::OniSplitProcSeparator,currentIndex+1);

            commandToExec=commands.mid(currentIndex,(nextIndex-currentIndex));
            this->myProcess->start(GlobalVars::OniSplitExeName+" "+commandToExec);
            this->myProcess->waitForFinished(-1);

            if(this->processHasKilled){ // If the process has killed there's no need to proceed with reading output or process more commands
                delete this->myProcess; //delete object and make pointer invalid
                this->myData->clear(); //clean list
                emit conversionAborted();
                return;
            }

            result=this->myProcess->readAllStandardError();

            if(!result.isEmpty()){ //if(!result.startsWith("Importing",Qt::CaseSensitive) && !result.startsWith("Importing",Qt::CaseSensitive)){ //case sensitive is faster
                //catch exception
                myLogger->writeString("Oni Split Error: \n"+this->myData->at(i)+"\n"+result);
                errorMessage=result;
                numErrors++;
            }

            if(nextIndex==-1){ //we got to the end, stop proccessing commands
                break;
            }
            currentIndex=nextIndex+1; //update currentIndex +1 for start after the separator
        }

        emit taskDone();
    }

    delete this->myProcess; //delete object and make pointer invalid
    this->myData->clear(); //clean list

    //let's cut it a bit, complete error is in log file.
    if(errorMessage.size()>600){
        //limit it at 400 characters (not counting the warning at the begin)
        errorMessage.remove(299,errorMessage.size()-600);
        errorMessage.insert(299,"\n \t ... \n");
        errorMessage.insert(0,"This error was been shortened. \nSee the complete error at Vago log file.\n\n");
    }

    emit resultConversion(errorMessage,numErrors);
}

// Kill the process if requested
void Converter::terminateCurrProcess(){
    this->myProcess->kill();
    this->processHasKilled=true;
    this->myLogger->writeString("Received signal to kill current OniSplit operation (user requested).");
}
