UNIT Unit4_Exporters;
INTERFACE
USES Classes, StrUtils, SysUtils, Math, Unit3_data, Unit6_imgfuncs;

PROCEDURE ExportDefLine(fileid:LongWord; line:String; create:Boolean);
PROCEDURE ExportDefFileHeader(fileid:LongWord);
PROCEDURE ExportDatFile(fileid:LongWord);

FUNCTION ExportTRAC(fileid:LongWord; convert:Boolean):Integer;
FUNCTION ExportTXAN(fileid:LongWord; convert:Boolean):Integer;
FUNCTION ExportTXMP(fileid:LongWord; convert:Boolean):Integer;
VAR
  ExportHandlers:Array[1..4] OF TExportHandlers=(
    (Ext:'ABNA'; needed:False),
    //(Ext:'AGDB'; needed:False),
    (Ext:'TRAC'; needed:True; Handler:ExportTRAC),
    (Ext:'TXAN'; needed:True; Handler:ExportTXAN),
    (Ext:'TXMP'; needed:True; Handler:ExportTXMP)
  );



IMPLEMENTATION
USES Unit2_functions;

PROCEDURE ExportDefLine(fileid:LongWord; line:String; create:Boolean);
  VAR
    filestream:TFileStream;
    data:Tdata;
    i:LongWord;
  BEGIN
    SetLength(data,Length(line)+2);
    FOR i:=1 TO Length(line) DO
      data[i-1]:=Ord(line[i]);
    data[Length(line)]:=13;
    data[Length(line)+1]:=10;

    IF create THEN
      filestream:=TFileStream.Create(GetExtractPath+'\'+GetWinFileName(fileid,'_DEF_'),fmCreate)
    ELSE BEGIN
      filestream:=TFileStream.Create(GetExtractPath+'\'+GetWinFileName(fileid,'_DEF_'),fmOpenWrite);
      filestream.Seek(0,soFromEnd);
    END;
    filestream.Write(data[0],Length(data));
    filestream.Free;
  END;

PROCEDURE ExportDefFileHeader(fileid:LongWord);
  BEGIN
    IF NOT DirectoryExists(GetExtractPath) THEN
      CreateDir(GetExtractPath);
    WITH dat_files[fileid] DO
    ExportDefLine(fileid,FormatNumber(fileid,5,'0')+':'+Name+':'+Extension+':'+IntToHex(Size,8)+':'+IntToHex(FileType,8),True);
  END;

PROCEDURE ExportDatFile(fileid:LongWord);
  VAR
    filestream:TFileStream;
    data:Tdata;
  BEGIN
    data:=LoadDatFile(fileid);
    filestream:=TFileStream.Create(GetExtractPath+'\'+GetWinFileName(fileid,'_DAT_'),fmCreate);
    filestream.Write(data[0],Length(data));
    filestream.Free;
  END;


FUNCTION ExportTRAC;
  VAR
    link:LongWord;
    linkcount:Word;
    i:LongWord;
  BEGIN
    Result:=export_noerror;

    LoadDatFilePart(fileid,$18,SizeOf(link),@link);
    link:=link DIV 256;
    ExportDefLine(fileid,FormatNumber(0,4,'0')+':LINKtoTRAC:'+FormatNumber(link,5,'0')+':'+dat_files[link].Name+':'+dat_files[link].Extension,False);

    LoadDatFilePart(fileid,$1E,SizeOf(linkcount),@linkcount);
    ExportDefLine(fileid,'TRAMLINKS:'+FormatNumber(linkcount,4,'0'),False);
    FOR i:=1 TO linkcount DO BEGIN
      LoadDatFilePart(fileid,$20+(i-1)*12+8,SizeOf(link),@link);
      link:=link DIV 256;
      ExportDefLine(fileid,FormatNumber(i,4,'0')+':LINKtoTRAM:'+FormatNumber(link,5,'0')+':'+dat_files[link].Name+':'+dat_files[link].Extension,False);
    END;
  END;

FUNCTION ExportTXAN;
  VAR
    loop_speed,unknown:Word;
    linkcount:LongWord;
    link:LongWord;
    i:Byte;
  BEGIN
    Result:=export_noerror;

    LoadDatFilePart(fileid,$14,SizeOf(loop_speed),@loop_speed);
    LoadDatFilePart(fileid,$16,SizeOf(unknown),@unknown);
    ExportDefLine(fileid,'LOOPSPEED:'+FormatNumber(loop_speed,2,'0'),False);
    ExportDefLine(fileid,'UNKNOWN:'+FormatNumber(unknown,2,'0'),False);

    LoadDatFilePart(fileid,$1C,SizeOf(linkcount),@linkcount);
    ExportDefLine(fileid,'TXMPLINKS:'+FormatNumber(linkcount,4,'0'),False);
    FOR i:=0 TO linkcount-1 DO BEGIN
      LoadDatFilePart(fileid,$20+i*4,SizeOf(link),@link);
      link:=link DIV 256;
      IF link=0 THEN link:=fileid-1;
      ExportDefLine(fileid,FormatNumber(i,4,'0')+':LINKtoTXMP:'+FormatNumber(link,5,'0')+':'+dat_files[link].Name+':'+dat_files[link].Extension,False);
    END;
  END;

FUNCTION ExportTXMP;
  VAR
    filestream:TFileStream;
    subfile:Byte;
    img:TImgPackage;
  BEGIN
    Result:=export_noerror;
    subfile:=1;

    img:=LoadImgData(fileid);

    filestream:=TFileStream.Create(GetExtractPath+'\'+GetWinFileName(fileid,FormatNumber(subfile,2,'0')+'-ImgData'),fmCreate);
    filestream.Write(img.imgdata[0],Length(img.imgdata));
    filestream.Free;

    IF convert THEN BEGIN
      img.imgdata:=ImgdataToBMP(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);
      filestream:=TFileStream.Create(GetExtractPath+'\'+GetWinFileName(fileid,FormatNumber(subfile,2,'0')+'-ImgData')+'.bmp',fmCreate);
      filestream.Write(img.imgdata[0],Length(img.imgdata));
      filestream.Free;
    END;
  END;

END.
